/*
 * Decompiled with CFR 0.152.
 */
package io.castled.apps;

import com.fasterxml.jackson.databind.JsonNode;
import com.google.common.collect.Lists;
import io.castled.apps.AppConfig;
import io.castled.apps.DataSink;
import io.castled.apps.dtos.AppSyncConfigDTO;
import io.castled.apps.models.ExternalAppSchema;
import io.castled.apps.syncconfigs.AppSyncConfig;
import io.castled.commons.models.AppSyncMode;
import io.castled.dtos.PipelineConfigDTO;
import io.castled.exceptions.connect.InvalidConfigException;
import io.castled.forms.FormUtils;
import io.castled.forms.dtos.FormFieldOption;
import io.castled.forms.dtos.FormFieldsDTO;
import io.castled.schema.models.RecordSchema;
import io.castled.utils.JsonUtils;
import java.util.List;
import javax.ws.rs.BadRequestException;

public interface ExternalAppConnector<CONFIG extends AppConfig, DATASINK extends DataSink, MAPPINGCONFIG extends AppSyncConfig> {
    public List<FormFieldOption> getAllObjects(CONFIG var1, MAPPINGCONFIG var2);

    default public FormFieldsDTO getMappingFields() {
        Class<MAPPINGCONFIG> mappingConfigClass = this.getMappingConfigType();
        return FormUtils.getFormFields(mappingConfigClass);
    }

    default public FormFieldsDTO getFormFields() {
        Class<CONFIG> appConfigClass = this.getAppConfigType();
        return FormUtils.getFormFields(appConfigClass);
    }

    public DATASINK getDataSink();

    public ExternalAppSchema getSchema(CONFIG var1, MAPPINGCONFIG var2);

    default public List<AppSyncMode> getSyncModes(CONFIG config, MAPPINGCONFIG appSyncConfig) {
        return Lists.newArrayList((Object[])new AppSyncMode[]{AppSyncMode.INSERT, AppSyncMode.UPDATE, AppSyncMode.UPSERT});
    }

    default public CONFIG enrichAppConfig(CONFIG appConfig) {
        return appConfig;
    }

    default public void validateAppConfig(CONFIG appConfig) throws InvalidConfigException {
    }

    default public PipelineConfigDTO validateAndEnrichPipelineConfig(PipelineConfigDTO pipelineConfig) throws BadRequestException {
        return pipelineConfig;
    }

    default public RecordSchema enrichWarehouseASchema(AppSyncConfigDTO appSyncConfigDTO, RecordSchema warehouseSchema) {
        return warehouseSchema;
    }

    default public CONFIG getAppConfig(JsonNode jsonNode) {
        return (CONFIG)((AppConfig)JsonUtils.jsonNodeToObject((JsonNode)jsonNode, this.getAppConfigType()));
    }

    default public MAPPINGCONFIG getAppSyncConfig(JsonNode jsonNode) {
        return (MAPPINGCONFIG)((AppSyncConfig)JsonUtils.jsonNodeToObject((JsonNode)jsonNode, this.getMappingConfigType()));
    }

    public Class<MAPPINGCONFIG> getMappingConfigType();

    public Class<CONFIG> getAppConfigType();
}

