/*
 * Decompiled with CFR 0.152.
 */
package io.castled.apps;

import com.google.inject.AbstractModule;
import com.google.inject.Binder;
import com.google.inject.Provides;
import com.google.inject.Singleton;
import com.google.inject.multibindings.MapBinder;
import io.castled.apps.connectors.customerio.CIOEventTypeFetcher;
import io.castled.apps.connectors.customerio.CIOPrimaryKeyOptionsFetcher;
import io.castled.apps.connectors.fbcustomaudience.FbAdAccountOptionsFetcher;
import io.castled.apps.connectors.fbcustomaudience.HashingOptionsFetcher;
import io.castled.apps.connectors.googleads.CustomerMatchTypeOptionsFetcher;
import io.castled.apps.connectors.googleads.GadAccountOptionsFetcher;
import io.castled.apps.connectors.googleads.GadsLoginCustomerOptionsFetcher;
import io.castled.apps.connectors.googleads.GoogleAdsSubResourceFetcher;
import io.castled.apps.connectors.intercom.IntercomCompanySink;
import io.castled.apps.connectors.intercom.IntercomContactSink;
import io.castled.apps.connectors.intercom.IntercomObject;
import io.castled.apps.connectors.intercom.IntercomObjectSink;
import io.castled.apps.connectors.sendgrid.SendgridListsOptionsFetcher;
import io.castled.apps.optionfetchers.AppOptionsFetcher;
import io.castled.commons.optionfetchers.AWSRegionOptionsFetcher;
import io.castled.commons.optionfetchers.ISO4217CurrencyCodesFetcher;
import io.castled.commons.optionfetchers.ZoneIdOptionsFetcher;
import io.castled.forms.StaticOptionsFetcher;
import io.castled.jdbc.JdbcConnectionType;
import io.castled.jdbc.JdbcQueryHelper;
import io.castled.jdbc.redshift.RedshiftQueryHelper;
import io.castled.jdbc.snowflake.SnowflakeQueryHelper;
import io.castled.optionsfetchers.appsync.AppSyncOptionsFetcher;
import io.castled.optionsfetchers.appsync.ObjectOptionsFetcher;
import io.castled.optionsfetchers.appsync.SyncModeOptionsFetcher;
import io.castled.warehouses.WarehouseConnectorConfig;
import io.castled.warehouses.connectors.bigquery.BQLocationsFetcher;
import io.castled.warehouses.connectors.postgres.PostgresQueryHelper;
import io.castled.warehouses.optionsfetchers.WarehouseOptionsFetcher;

public class ConnectorsModule
extends AbstractModule {
    private final WarehouseConnectorConfig warehouseConnectorConfig;

    public ConnectorsModule(WarehouseConnectorConfig warehouseConnectorConfig) {
        this.warehouseConnectorConfig = warehouseConnectorConfig;
    }

    protected void configure() {
        this.bindIntercomObjectSinks();
        this.bindWarehouseOptionFetchers();
        this.bindAppSyncOptions();
        this.bindJdbcQueryHelpers();
        this.bindStaticOptionFetchers();
        this.bindWarehouseOptionFetchers();
        this.bindAppOptionFetchers();
    }

    private void bindWarehouseOptionFetchers() {
        MapBinder warehouseOptionFetchers = MapBinder.newMapBinder((Binder)this.binder(), String.class, WarehouseOptionsFetcher.class);
    }

    private void bindAppOptionFetchers() {
        MapBinder warehouseOptionFetchers = MapBinder.newMapBinder((Binder)this.binder(), String.class, AppOptionsFetcher.class);
    }

    private void bindJdbcQueryHelpers() {
        MapBinder queryHelpers = MapBinder.newMapBinder((Binder)this.binder(), JdbcConnectionType.class, JdbcQueryHelper.class);
        queryHelpers.addBinding((Object)JdbcConnectionType.REDSHIFT).to(RedshiftQueryHelper.class);
        queryHelpers.addBinding((Object)JdbcConnectionType.SNOWFLAKE).to(SnowflakeQueryHelper.class);
        queryHelpers.addBinding((Object)JdbcConnectionType.POSTGRES).to(PostgresQueryHelper.class);
    }

    private void bindAppSyncOptions() {
        MapBinder optionFetchers = MapBinder.newMapBinder((Binder)this.binder(), String.class, AppSyncOptionsFetcher.class);
        optionFetchers.addBinding((Object)"Object").to(ObjectOptionsFetcher.class);
        optionFetchers.addBinding((Object)"Sync Mode").to(SyncModeOptionsFetcher.class);
        optionFetchers.addBinding((Object)"Gads Account Id").to(GadAccountOptionsFetcher.class);
        optionFetchers.addBinding((Object)"Gads Login Account Id").to(GadsLoginCustomerOptionsFetcher.class);
        optionFetchers.addBinding((Object)"Sendgrid Lists").to(SendgridListsOptionsFetcher.class);
        optionFetchers.addBinding((Object)"CIO Primary keys").to(CIOPrimaryKeyOptionsFetcher.class);
        optionFetchers.addBinding((Object)"CIO Event Types").to(CIOEventTypeFetcher.class);
        optionFetchers.addBinding((Object)"gads_sub_resource").to(GoogleAdsSubResourceFetcher.class);
        optionFetchers.addBinding((Object)"Facebook Ad Accounts").to(FbAdAccountOptionsFetcher.class);
    }

    private void bindStaticOptionFetchers() {
        MapBinder staticOptionFetcher = MapBinder.newMapBinder((Binder)this.binder(), String.class, StaticOptionsFetcher.class);
        staticOptionFetcher.addBinding((Object)"GCP_LOCATIONS").to(BQLocationsFetcher.class);
        staticOptionFetcher.addBinding((Object)"CUSTOMER_MATCH_TYPE").to(CustomerMatchTypeOptionsFetcher.class);
        staticOptionFetcher.addBinding((Object)"AWS_REGIONS").to(AWSRegionOptionsFetcher.class);
        staticOptionFetcher.addBinding((Object)"ZONE_IDS").to(ZoneIdOptionsFetcher.class);
        staticOptionFetcher.addBinding((Object)"CURRENCY_CODES").to(ISO4217CurrencyCodesFetcher.class);
        staticOptionFetcher.addBinding((Object)"Hashing Required").to(HashingOptionsFetcher.class);
    }

    private void bindIntercomObjectSinks() {
        MapBinder pipelineDataSinks = MapBinder.newMapBinder((Binder)this.binder(), IntercomObject.class, IntercomObjectSink.class);
        pipelineDataSinks.addBinding((Object)IntercomObject.COMPANY).to(IntercomCompanySink.class);
        pipelineDataSinks.addBinding((Object)IntercomObject.CONTACT).to(IntercomContactSink.class);
        pipelineDataSinks.addBinding((Object)IntercomObject.USER).to(IntercomContactSink.class);
        pipelineDataSinks.addBinding((Object)IntercomObject.LEAD).to(IntercomContactSink.class);
    }

    @Provides
    @Singleton
    public WarehouseConnectorConfig providesWarehouseConfig() {
        return this.warehouseConnectorConfig;
    }
}

