/*
 * Decompiled with CFR 0.152.
 */
package io.castled.warehouses.connectors.bigquery.gcp;

import com.github.benmanes.caffeine.cache.Cache;
import com.github.benmanes.caffeine.cache.Caffeine;
import com.google.auth.Credentials;
import com.google.auth.oauth2.GoogleCredentials;
import com.google.cloud.TransportOptions;
import com.google.cloud.bigquery.BigQuery;
import com.google.cloud.bigquery.BigQueryOptions;
import com.google.cloud.http.HttpTransportOptions;
import com.google.cloud.storage.Storage;
import com.google.cloud.storage.StorageOptions;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import io.castled.commons.models.ServiceAccountDetails;
import io.castled.exceptions.CastledRuntimeException;
import io.castled.filestorage.GcsClient;
import io.castled.utils.JsonUtils;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collections;
import java.util.concurrent.TimeUnit;
import org.jdbi.v3.core.Jdbi;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class GcpClientFactory {
    private static final Logger log = LoggerFactory.getLogger(GcpClientFactory.class);
    private final Cache<CacheKey, BigQuery> bigQueryClientCache = Caffeine.newBuilder().expireAfterWrite(3L, TimeUnit.HOURS).maximumSize(1000L).build();
    private final Cache<CacheKey, GcsClient> gcsClientCache = Caffeine.newBuilder().expireAfterWrite(3L, TimeUnit.HOURS).maximumSize(1000L).build();

    @Inject
    public GcpClientFactory(Jdbi jdbi) {
    }

    public BigQuery getBigQuery(ServiceAccountDetails serviceAccountDetails, String projectId) {
        CacheKey cacheKey = new CacheKey(serviceAccountDetails.getClientId(), serviceAccountDetails.getClientEmail(), serviceAccountDetails.getProjectId(), projectId);
        return (BigQuery)this.bigQueryClientCache.get((Object)cacheKey, cacheKeyRef -> {
            Credentials credentials = this.getCredentials(serviceAccountDetails);
            HttpTransportOptions transportOptions = BigQueryOptions.getDefaultHttpTransportOptions().toBuilder().setConnectTimeout(60000).setReadTimeout(120000).build();
            return (BigQuery)((BigQueryOptions.Builder)((BigQueryOptions.Builder)BigQueryOptions.newBuilder().setProjectId(projectId)).setTransportOptions((TransportOptions)transportOptions).setCredentials(credentials)).build().getService();
        });
    }

    public GcsClient getGcsClient(ServiceAccountDetails serviceAccountDetails, String projectId) {
        CacheKey cacheKey = new CacheKey(serviceAccountDetails.getClientId(), serviceAccountDetails.getClientEmail(), serviceAccountDetails.getProjectId(), projectId);
        return (GcsClient)this.gcsClientCache.get((Object)cacheKey, cacheKeyRef -> new GcsClient((Storage)((StorageOptions.Builder)((StorageOptions.Builder)StorageOptions.newBuilder().setProjectId(projectId)).setCredentials(this.getCredentials(serviceAccountDetails))).build().getService()));
    }

    public Credentials getCredentials(ServiceAccountDetails serviceAccountDetails) {
        try {
            ByteArrayInputStream serviceAccountStream = new ByteArrayInputStream(JsonUtils.objectToByteArray((Object)serviceAccountDetails));
            return GoogleCredentials.fromStream((InputStream)serviceAccountStream).createScoped(Collections.singleton("https://www.googleapis.com/auth/cloud-platform"));
        }
        catch (IOException e) {
            log.error(String.format("Service account credentials fetch failed for %s", serviceAccountDetails.getClientEmail()));
            throw new CastledRuntimeException((Throwable)e);
        }
    }

    private static final class CacheKey {
        private String clientId;
        private String clientEmail;
        private String clientProjectId;
        private String projectId;

        public String getClientId() {
            return this.clientId;
        }

        public String getClientEmail() {
            return this.clientEmail;
        }

        public String getClientProjectId() {
            return this.clientProjectId;
        }

        public String getProjectId() {
            return this.projectId;
        }

        public void setClientId(String clientId) {
            this.clientId = clientId;
        }

        public void setClientEmail(String clientEmail) {
            this.clientEmail = clientEmail;
        }

        public void setClientProjectId(String clientProjectId) {
            this.clientProjectId = clientProjectId;
        }

        public void setProjectId(String projectId) {
            this.projectId = projectId;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof CacheKey)) {
                return false;
            }
            CacheKey other = (CacheKey)o;
            String this$clientId = this.getClientId();
            String other$clientId = other.getClientId();
            if (this$clientId == null ? other$clientId != null : !this$clientId.equals(other$clientId)) {
                return false;
            }
            String this$clientEmail = this.getClientEmail();
            String other$clientEmail = other.getClientEmail();
            if (this$clientEmail == null ? other$clientEmail != null : !this$clientEmail.equals(other$clientEmail)) {
                return false;
            }
            String this$clientProjectId = this.getClientProjectId();
            String other$clientProjectId = other.getClientProjectId();
            if (this$clientProjectId == null ? other$clientProjectId != null : !this$clientProjectId.equals(other$clientProjectId)) {
                return false;
            }
            String this$projectId = this.getProjectId();
            String other$projectId = other.getProjectId();
            return !(this$projectId == null ? other$projectId != null : !this$projectId.equals(other$projectId));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $clientId = this.getClientId();
            result = result * 59 + ($clientId == null ? 43 : $clientId.hashCode());
            String $clientEmail = this.getClientEmail();
            result = result * 59 + ($clientEmail == null ? 43 : $clientEmail.hashCode());
            String $clientProjectId = this.getClientProjectId();
            result = result * 59 + ($clientProjectId == null ? 43 : $clientProjectId.hashCode());
            String $projectId = this.getProjectId();
            result = result * 59 + ($projectId == null ? 43 : $projectId.hashCode());
            return result;
        }

        public String toString() {
            return "GcpClientFactory.CacheKey(clientId=" + this.getClientId() + ", clientEmail=" + this.getClientEmail() + ", clientProjectId=" + this.getClientProjectId() + ", projectId=" + this.getProjectId() + ")";
        }

        public CacheKey(String clientId, String clientEmail, String clientProjectId, String projectId) {
            this.clientId = clientId;
            this.clientEmail = clientEmail;
            this.clientProjectId = clientProjectId;
            this.projectId = projectId;
        }

        public CacheKey() {
        }
    }
}

