/*
 * Decompiled with CFR 0.152.
 */
package io.castled.warehouses.connectors.bigquery;

import io.castled.commons.models.ServiceAccountDetails;
import io.castled.forms.CodeBlock;
import io.castled.forms.CodeSnippet;
import io.castled.forms.FormField;
import io.castled.forms.FormFieldSchema;
import io.castled.forms.FormFieldType;
import io.castled.forms.GroupActivator;
import io.castled.forms.OptionsRef;
import io.castled.forms.OptionsRefType;
import io.castled.warehouses.WarehouseConfig;

@CodeBlock(title="Run the following commands on the google cloud console", dependencies={"projectId", "bucketName", "serviceAccount"}, snippets={@CodeSnippet(title="BQ Data Viewer Role", ref="bq_data_viewer_access"), @CodeSnippet(title="BQ User Role", ref="bq_data_user_access"), @CodeSnippet(title="GCP Storage Admin Role", ref="gcp_storage_admin_access")})
@GroupActivator(dependencies={"projectId", "bucketName", "location"}, group="service_account")
public class BigQueryWarehouseConfig
extends WarehouseConfig {
    @FormField(description="Project Id", title="Project Id", placeholder="", schema=FormFieldSchema.STRING, type=FormFieldType.TEXT_BOX)
    private String projectId;
    @FormField(description="GCS Bucket Name", title="GCS Bucket Name", placeholder="", schema=FormFieldSchema.STRING, type=FormFieldType.TEXT_BOX)
    private String bucketName;
    @FormField(description="Dataset location", title="Dataset location", schema=FormFieldSchema.STRING, type=FormFieldType.DROP_DOWN, optionsRef=@OptionsRef(value="BQ_LOCATIONS", type=OptionsRefType.STATIC))
    private String location;
    @FormField(type=FormFieldType.JSON_FILE, description="Service Account Json File", title="Service Account Json File", group="service_account")
    private ServiceAccountDetails serviceAccount;

    public String getProjectId() {
        return this.projectId;
    }

    public String getBucketName() {
        return this.bucketName;
    }

    public String getLocation() {
        return this.location;
    }

    public ServiceAccountDetails getServiceAccount() {
        return this.serviceAccount;
    }

    public void setProjectId(String projectId) {
        this.projectId = projectId;
    }

    public void setBucketName(String bucketName) {
        this.bucketName = bucketName;
    }

    public void setLocation(String location) {
        this.location = location;
    }

    public void setServiceAccount(ServiceAccountDetails serviceAccount) {
        this.serviceAccount = serviceAccount;
    }
}

