/*
 * Decompiled with CFR 0.152.
 */
package io.castled.warehouses.connectors.bigquery;

import com.google.cloud.bigquery.BigQuery;
import com.google.cloud.bigquery.FormatOptions;
import com.google.cloud.bigquery.JobConfiguration;
import com.google.cloud.bigquery.JobInfo;
import com.google.cloud.bigquery.LoadJobConfiguration;
import com.google.cloud.bigquery.QueryJobConfiguration;
import com.google.cloud.bigquery.TableId;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import io.castled.ObjectRegistry;
import io.castled.commons.models.FileStorageNamespace;
import io.castled.constants.ConnectorExecutionConstants;
import io.castled.filemanager.RawFileWriter;
import io.castled.filestorage.GcsClient;
import io.castled.models.QueryMode;
import io.castled.schema.models.FieldSchema;
import io.castled.schema.models.Tuple;
import io.castled.utils.FileUtils;
import io.castled.utils.JsonUtils;
import io.castled.utils.SizeUtils;
import io.castled.warehouses.WarehouseConfig;
import io.castled.warehouses.WarehouseConnectorConfig;
import io.castled.warehouses.WarehouseSyncFailureListener;
import io.castled.warehouses.connectors.bigquery.BQSnapshotTracker;
import io.castled.warehouses.connectors.bigquery.BQWarehouseCopyAdaptor;
import io.castled.warehouses.connectors.bigquery.BigQueryUtils;
import io.castled.warehouses.connectors.bigquery.BigQueryWarehouseConfig;
import io.castled.warehouses.connectors.bigquery.daos.BQSnapshotTrackerDAO;
import io.castled.warehouses.connectors.bigquery.gcp.GcpClientFactory;
import io.castled.warehouses.models.WarehousePollContext;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.HashMap;
import java.util.List;
import java.util.UUID;
import org.jdbi.v3.core.Jdbi;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BQSyncFailureListener
extends WarehouseSyncFailureListener {
    private static final Logger log = LoggerFactory.getLogger(BQSyncFailureListener.class);
    private final WarehousePollContext warehousePollContext;
    private final RawFileWriter rawFileWriter;
    private final BigQueryWarehouseConfig warehouseConfig;
    private final String gcsUploadDirectory;
    private final GcsClient gcsClient;
    private final String bucket;
    private final List<String> gcsFileUrls = Lists.newArrayList();
    private final BQSnapshotTrackerDAO bqSnapshotTrackerDAO;
    private int totalBytes = 0;
    private long failedRecords = 0L;

    public BQSyncFailureListener(WarehousePollContext warehousePollContext) {
        super(warehousePollContext);
        this.warehousePollContext = warehousePollContext;
        this.rawFileWriter = new RawFileWriter(SizeUtils.convertMBToBytes((long)50L), this.failureRecordsDirectory, () -> UUID.randomUUID().toString());
        this.warehouseConfig = (BigQueryWarehouseConfig)warehousePollContext.getWarehouseConfig();
        this.gcsClient = ((GcpClientFactory)ObjectRegistry.getInstance(GcpClientFactory.class)).getGcsClient(this.warehouseConfig.getServiceAccount(), this.warehouseConfig.getProjectId());
        this.gcsUploadDirectory = GcsClient.constructObjectKey(Lists.newArrayList((Object[])new String[]{FileStorageNamespace.PIPELINE_FAILED_RECORDS.getNamespace(), warehousePollContext.getPipelineUUID(), String.valueOf(warehousePollContext.getPipelineRunId())}));
        this.bucket = this.warehouseConfig.getBucketName();
        this.bqSnapshotTrackerDAO = (BQSnapshotTrackerDAO)((Jdbi)ObjectRegistry.getInstance(Jdbi.class)).onDemand(BQSnapshotTrackerDAO.class);
    }

    @Override
    public void cleanupResources(String pipelineUUID, Long pipelineRunId, WarehouseConfig warehouseConfig) {
        BigQueryWarehouseConfig bigQueryWarehouseConfig = (BigQueryWarehouseConfig)warehouseConfig;
        GcsClient gcsClient = ((GcpClientFactory)ObjectRegistry.getInstance(GcpClientFactory.class)).getGcsClient(bigQueryWarehouseConfig.getServiceAccount(), bigQueryWarehouseConfig.getProjectId());
        gcsClient.deleteDirectory(bigQueryWarehouseConfig.getBucketName(), this.gcsUploadDirectory);
        FileUtils.deleteDirectory((Path)this.failureRecordsDirectory);
    }

    @Override
    public void doFlush() throws Exception {
        if (this.warehousePollContext.getQueryMode() == QueryMode.FULL_LOAD) {
            return;
        }
        if (this.totalBytes > 0) {
            this.rawFileWriter.close();
            this.uploadFilesToGCS();
        }
        BigQuery bigQuery = ((GcpClientFactory)ObjectRegistry.getInstance(GcpClientFactory.class)).getBigQuery(this.warehouseConfig.getServiceAccount(), this.warehouseConfig.getProjectId());
        BQSnapshotTracker bqSnapshotTracker = this.bqSnapshotTrackerDAO.getSnapshotTracker(this.warehousePollContext.getPipelineUUID());
        if (this.failedRecords > 0L) {
            this.removeFailedRecordsFromSnapshot(bigQuery, bqSnapshotTracker);
        }
        this.commitSnapshot(bigQuery, bqSnapshotTracker);
    }

    private void commitSnapshot(BigQuery bigQuery, BQSnapshotTracker bqSnapshotTracker) {
        String prevCommittedSnapshot = bqSnapshotTracker.getCommittedSnapshot();
        this.bqSnapshotTrackerDAO.commitSnapshot(this.warehousePollContext.getPipelineUUID());
        if (prevCommittedSnapshot != null) {
            bigQuery.delete(TableId.of((String)"castled", (String)prevCommittedSnapshot));
        }
    }

    private void removeFailedRecordsFromSnapshot(BigQuery bigQuery, BQSnapshotTracker bqSnapshotTracker) throws Exception {
        String failedRecordsTable = ConnectorExecutionConstants.getFailedRecordsTable(this.warehousePollContext.getPipelineUUID());
        String failedRecordsCreateQuery = String.format("select %s from %s.%s limit 0", String.join((CharSequence)",", this.trackableFields), "castled", bqSnapshotTracker.getUncommittedSnapshot());
        bigQuery.query(QueryJobConfiguration.newBuilder((String)failedRecordsCreateQuery).setDestinationTable(TableId.of((String)"castled", (String)failedRecordsTable)).setWriteDisposition(JobInfo.WriteDisposition.WRITE_TRUNCATE).build(), new BigQuery.JobOption[0]);
        LoadJobConfiguration loadJobConfiguration = LoadJobConfiguration.newBuilder((TableId)TableId.of((String)"castled", (String)ConnectorExecutionConstants.getFailedRecordsTable(this.warehousePollContext.getPipelineUUID())), this.gcsFileUrls, (FormatOptions)FormatOptions.json()).setIgnoreUnknownValues(Boolean.valueOf(true)).build();
        BigQueryUtils.runJob(bigQuery.create(JobInfo.newBuilder((JobConfiguration)loadJobConfiguration).build(), new BigQuery.JobOption[0]));
        this.gcsClient.deleteDirectory(this.bucket, this.gcsUploadDirectory);
        StringBuilder mergeQueryBuilder = new StringBuilder(String.format("MERGE %s.%s T using %s.%s S on 1 = 1", "castled", bqSnapshotTracker.getUncommittedSnapshot(), "castled", failedRecordsTable));
        for (String trackableField : this.trackableFields) {
            mergeQueryBuilder.append(String.format(" AND (T.%s = S.%s OR (T.%s IS NULL and S.%s IS NULL))", trackableField, trackableField, trackableField, trackableField));
        }
        mergeQueryBuilder.append(" WHEN MATCHED THEN DELETE");
        BigQueryUtils.runJob(bigQuery.create(JobInfo.newBuilder((JobConfiguration)QueryJobConfiguration.newBuilder((String)mergeQueryBuilder.toString()).build()).build(), new BigQuery.JobOption[0]));
        bigQuery.delete(TableId.of((String)"castled", (String)ConnectorExecutionConstants.getFailedRecordsTable(this.warehousePollContext.getPipelineUUID())));
    }

    @Override
    public synchronized void doWriteRecord(Tuple tuple) throws Exception {
        if (this.warehousePollContext.getQueryMode() == QueryMode.FULL_LOAD) {
            return;
        }
        String record = this.getCopyableRecord(tuple);
        byte[] recordBytes = record.getBytes();
        this.rawFileWriter.writeRecord(recordBytes);
        this.totalBytes += recordBytes.length;
        ++this.failedRecords;
        if ((long)this.totalBytes > SizeUtils.convertGBToBytes((long)((WarehouseConnectorConfig)ObjectRegistry.getInstance(WarehouseConnectorConfig.class)).getFailedRecordBufferSize())) {
            this.rawFileWriter.close();
            this.uploadFilesToGCS();
            if (!Files.exists(this.failureRecordsDirectory, new LinkOption[0])) {
                Files.createDirectory(this.failureRecordsDirectory, new FileAttribute[0]);
            }
        }
    }

    private void uploadFilesToGCS() throws Exception {
        this.gcsFileUrls.addAll(this.gcsClient.uploadDirectory(this.bucket, this.failureRecordsDirectory, this.gcsUploadDirectory));
        FileUtils.deleteDirectory((Path)this.failureRecordsDirectory);
    }

    private String getCopyableRecord(Tuple record) {
        BQWarehouseCopyAdaptor bqWarehouseCopyAdaptor = (BQWarehouseCopyAdaptor)ObjectRegistry.getInstance(BQWarehouseCopyAdaptor.class);
        HashMap copyableValues = Maps.newHashMap();
        for (FieldSchema fieldSchema : this.warehousePollContext.getWarehouseSchema().getFieldSchemas()) {
            if (!this.trackableFields.contains(fieldSchema.getName())) continue;
            copyableValues.put(fieldSchema.getName(), bqWarehouseCopyAdaptor.constructSyncableRecord(record.getValue(fieldSchema.getName()), fieldSchema.getSchema()));
        }
        return JsonUtils.objectToString((Object)copyableValues);
    }
}

