/*
 * Decompiled with CFR 0.152.
 */
package io.castled.warehouses;

import com.fasterxml.jackson.annotation.JsonIgnore;
import io.castled.forms.FormField;
import io.castled.forms.FormFieldSchema;
import io.castled.forms.FormFieldType;
import io.castled.forms.GroupActivator;
import io.castled.tunnel.SSHTunnelParams;
import io.castled.warehouses.WarehouseConfig;

@GroupActivator(dependencies={"tunnelEnabled"}, group="tunnel")
public class TunneledWarehouseConfig
extends WarehouseConfig {
    @FormField(description="SSH Host", schema=FormFieldSchema.STRING, group="tunnel", title="SSH Host", placeholder="", type=FormFieldType.TEXT_BOX)
    private String sshHost;
    @FormField(description="SSH Port", title="SSH Port", placeholder="", schema=FormFieldSchema.NUMBER, group="tunnel", type=FormFieldType.TEXT_BOX)
    private int sshPort;
    @FormField(description="SSH User", title="SSH User", placeholder="", schema=FormFieldSchema.STRING, group="tunnel", type=FormFieldType.TEXT_BOX)
    private String sshUser;
    @FormField(description="Enable SSH Tunnel", title="Enable Tunnel", schema=FormFieldSchema.BOOLEAN, type=FormFieldType.CHECK_BOX)
    private boolean tunnelEnabled;
    @FormField(description="Private Key file", title="Private Key file", schema=FormFieldSchema.STRING, group="tunnel", type=FormFieldType.TEXT_FILE)
    private String privateKey;
    @FormField(description="SSH passphrase", title="SSH passphrase", schema=FormFieldSchema.STRING, group="tunnel", type=FormFieldType.TEXT_BOX)
    private String passPhrase;

    @JsonIgnore
    public SSHTunnelParams getSSHTunnelParams() {
        if (!this.tunnelEnabled) {
            return null;
        }
        String sshHost = this.getSshHost();
        int sshPort = this.getSshPort();
        String sshUser = this.getSshUser();
        return new SSHTunnelParams(sshHost, sshUser, sshPort, this.privateKey, this.passPhrase);
    }

    public String getSshHost() {
        return this.sshHost;
    }

    public int getSshPort() {
        return this.sshPort;
    }

    public String getSshUser() {
        return this.sshUser;
    }

    public boolean isTunnelEnabled() {
        return this.tunnelEnabled;
    }

    public String getPrivateKey() {
        return this.privateKey;
    }

    public String getPassPhrase() {
        return this.passPhrase;
    }

    public void setSshHost(String sshHost) {
        this.sshHost = sshHost;
    }

    public void setSshPort(int sshPort) {
        this.sshPort = sshPort;
    }

    public void setSshUser(String sshUser) {
        this.sshUser = sshUser;
    }

    public void setTunnelEnabled(boolean tunnelEnabled) {
        this.tunnelEnabled = tunnelEnabled;
    }

    public void setPrivateKey(String privateKey) {
        this.privateKey = privateKey;
    }

    public void setPassPhrase(String passPhrase) {
        this.passPhrase = passPhrase;
    }
}

