/*
 * Decompiled with CFR 0.152.
 */
package io.castled.oauth;

import com.google.api.client.googleapis.auth.oauth2.GoogleAuthorizationCodeFlow;
import com.google.api.client.googleapis.auth.oauth2.GoogleTokenResponse;
import com.google.api.client.googleapis.javanet.GoogleNetHttpTransport;
import com.google.api.client.http.HttpTransport;
import com.google.api.client.json.JsonFactory;
import com.google.api.client.json.jackson2.JacksonFactory;
import com.google.common.collect.Lists;
import io.castled.exceptions.CastledRuntimeException;
import io.castled.oauth.BaseOauthAccessProvider;
import io.castled.oauth.OAuthAccessConfig;
import io.castled.oauth.OAuthClientConfig;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.jose4j.jwt.consumer.JwtConsumerBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class GoogleOAuthAccessProvider
extends BaseOauthAccessProvider {
    private static final Logger log = LoggerFactory.getLogger(GoogleOAuthAccessProvider.class);
    public static final String USERINFO_EMAIL = "https://www.googleapis.com/auth/userinfo.email";
    private final GoogleAuthorizationCodeFlow authorizationCodeFlow;

    public GoogleOAuthAccessProvider(OAuthClientConfig oAuthClientConfig) throws Exception {
        this.authorizationCodeFlow = new GoogleAuthorizationCodeFlow.Builder((HttpTransport)GoogleNetHttpTransport.newTrustedTransport(), (JsonFactory)JacksonFactory.getDefaultInstance(), oAuthClientConfig.getClientId(), oAuthClientConfig.getClientSecret(), this.getAuthorizationScopes()).setAccessType("offline").setApprovalPrompt("force").build();
    }

    public List<String> getAuthorizationScopes() {
        ArrayList scopes = Lists.newArrayList();
        if (!scopes.contains(USERINFO_EMAIL)) {
            scopes.add(USERINFO_EMAIL);
        }
        scopes.addAll(this.getScopes());
        return scopes;
    }

    public abstract List<String> getScopes();

    @Override
    public String getAuthorizationUrl(String stateId, String redirectUri, String clientId) {
        return this.authorizationCodeFlow.newAuthorizationUrl().setRedirectUri(redirectUri).setState(stateId).build();
    }

    @Override
    public OAuthAccessConfig getAccessConfig(String authorizationCode, String redirectUri) {
        try {
            GoogleTokenResponse response = this.authorizationCodeFlow.newTokenRequest(authorizationCode).setRedirectUri(redirectUri).execute();
            String accessToken = response.getAccessToken();
            String refreshToken = response.getRefreshToken();
            Map claimsMap = new JwtConsumerBuilder().setSkipSignatureVerification().setSkipDefaultAudienceValidation().build().processToClaims(response.getIdToken()).getClaimsMap();
            String email = (String)claimsMap.get("email");
            return this.doGetAccessConfig(accessToken, refreshToken, email);
        }
        catch (Exception e) {
            log.error("Get Access config failed", (Throwable)e);
            throw new CastledRuntimeException((Throwable)e);
        }
    }

    public abstract OAuthAccessConfig doGetAccessConfig(String var1, String var2, String var3);
}

