/*
 * Decompiled with CFR 0.152.
 */
package io.castled.models;

import io.castled.models.FieldMapping;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public class CastledDataMapping {
    private List<String> primaryKeys;
    private List<FieldMapping> fieldMappings;

    public Map<String, String> getMappingForAppFields(List<String> appFields) {
        return this.fieldMappings.stream().filter(fieldMapping -> appFields.contains(fieldMapping.getAppField())).collect(Collectors.toMap(FieldMapping::getAppField, FieldMapping::getWarehouseField));
    }

    public Map<String, String> appWarehouseMapping() {
        return this.fieldMappings.stream().filter(fieldMapping -> !fieldMapping.isSkipped()).collect(Collectors.toMap(FieldMapping::getAppField, FieldMapping::getWarehouseField));
    }

    public Map<String, String> warehouseAppMapping() {
        return this.fieldMappings.stream().filter(fieldMapping -> !fieldMapping.isSkipped()).collect(Collectors.toMap(FieldMapping::getWarehouseField, FieldMapping::getAppField));
    }

    public void addAdditionalMappings(List<FieldMapping> additionalMappings) {
        this.fieldMappings.addAll(additionalMappings);
    }

    public void addAdditionalMapping(FieldMapping additionalMapping) {
        this.fieldMappings.add(additionalMapping);
    }

    public List<String> getPrimaryKeys() {
        return this.primaryKeys;
    }

    public List<FieldMapping> getFieldMappings() {
        return this.fieldMappings;
    }

    public void setPrimaryKeys(List<String> primaryKeys) {
        this.primaryKeys = primaryKeys;
    }

    public void setFieldMappings(List<FieldMapping> fieldMappings) {
        this.fieldMappings = fieldMappings;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof CastledDataMapping)) {
            return false;
        }
        CastledDataMapping other = (CastledDataMapping)o;
        if (!other.canEqual(this)) {
            return false;
        }
        List<String> this$primaryKeys = this.getPrimaryKeys();
        List<String> other$primaryKeys = other.getPrimaryKeys();
        if (this$primaryKeys == null ? other$primaryKeys != null : !((Object)this$primaryKeys).equals(other$primaryKeys)) {
            return false;
        }
        List<FieldMapping> this$fieldMappings = this.getFieldMappings();
        List<FieldMapping> other$fieldMappings = other.getFieldMappings();
        return !(this$fieldMappings == null ? other$fieldMappings != null : !((Object)this$fieldMappings).equals(other$fieldMappings));
    }

    protected boolean canEqual(Object other) {
        return other instanceof CastledDataMapping;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        List<String> $primaryKeys = this.getPrimaryKeys();
        result = result * 59 + ($primaryKeys == null ? 43 : ((Object)$primaryKeys).hashCode());
        List<FieldMapping> $fieldMappings = this.getFieldMappings();
        result = result * 59 + ($fieldMappings == null ? 43 : ((Object)$fieldMappings).hashCode());
        return result;
    }

    public String toString() {
        return "CastledDataMapping(primaryKeys=" + this.getPrimaryKeys() + ", fieldMappings=" + this.getFieldMappings() + ")";
    }
}

