/*
 * Decompiled with CFR 0.152.
 */
package io.castled.filestorage;

import com.google.api.gax.paging.Page;
import com.google.cloud.storage.Blob;
import com.google.cloud.storage.BlobId;
import com.google.cloud.storage.BlobInfo;
import com.google.cloud.storage.Storage;
import com.google.common.collect.Lists;
import com.google.common.collect.Streams;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GcsClient {
    private static final Logger log = LoggerFactory.getLogger(GcsClient.class);
    private final Storage storage;
    private static final String SCHEME = "gs://";
    public static final String PATH_SEPARATOR = "/";

    public GcsClient(Storage storage) {
        this.storage = storage;
    }

    public static String constructGcsPath(String bucket, List<String> keyParts) {
        return String.format("%s%s%s", SCHEME, bucket + PATH_SEPARATOR, String.join((CharSequence)PATH_SEPARATOR, keyParts));
    }

    public static String constructObjectKey(List<String> keyParts) {
        return String.join((CharSequence)PATH_SEPARATOR, keyParts);
    }

    public List<Blob> listObjects(String bucket, String prefix) {
        Page blobPage = this.storage.list(bucket, new Storage.BlobListOption[]{Storage.BlobListOption.prefix((String)prefix)});
        return Streams.stream((Iterable)blobPage.iterateAll()).collect(Collectors.toList());
    }

    public List<Path> downloadFiles(List<Blob> gcsFiles, Path downloadDirectory) throws IOException {
        ArrayList downloadedFiles = Lists.newArrayList();
        for (Blob gcsFile : gcsFiles) {
            Path file = downloadDirectory.resolve(UUID.randomUUID().toString());
            log.info("Download files started for files {}", (Object)gcsFiles.size());
            gcsFile.downloadTo(file);
            log.info("Download files finished for files {}", (Object)gcsFiles.size());
            downloadedFiles.add(file);
        }
        return downloadedFiles;
    }

    public List<String> uploadDirectory(String bucket, Path localDirectory, String gcsDirectory) throws IOException {
        ArrayList uploadedFiles = Lists.newArrayList();
        for (Path path : Files.list(localDirectory).collect(Collectors.toList())) {
            String gcsFilePath = GcsClient.constructObjectKey(Lists.newArrayList((Object[])new String[]{gcsDirectory, path.getFileName().toString()}));
            uploadedFiles.add(GcsClient.constructGcsPath(bucket, Lists.newArrayList((Object[])new String[]{gcsDirectory, path.getFileName().toString()})));
            this.storage.create(BlobInfo.newBuilder((BlobId)BlobId.of((String)bucket, (String)gcsFilePath)).setContentType("text/plain").build(), Files.readAllBytes(path), new Storage.BlobTargetOption[0]);
        }
        return uploadedFiles;
    }

    public void deleteDirectory(String bucket, String gcsDirectory) {
        List<Blob> allBlobs = this.listObjects(bucket, gcsDirectory);
        for (Blob blob : allBlobs) {
            blob.delete(new Blob.BlobSourceOption[0]);
        }
    }

    public Storage getStorage() {
        return this.storage;
    }
}

