/*
 * Decompiled with CFR 0.152.
 */
package io.castled.commons.streams;

import io.castled.ObjectRegistry;
import io.castled.commons.streams.RecordInputStream;
import io.castled.exceptions.CastledRuntimeException;
import io.castled.schema.models.RecordSchema;
import io.castled.schema.models.Tuple;
import io.castled.warehouses.connectors.postgres.PostgresResultSetSchemaMapper;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JdbcRecordInputStream
implements RecordInputStream {
    private static final Logger log = LoggerFactory.getLogger(JdbcRecordInputStream.class);
    private final ResultSet resultSet;
    private final Connection connection;
    private final Statement statement;
    private final RecordSchema recordSchema;

    public JdbcRecordInputStream(Connection connection, String query, RecordSchema querySchema) {
        try {
            this.connection = connection;
            this.connection.setAutoCommit(false);
            this.statement = connection.createStatement();
            this.resultSet = this.statement.executeQuery(query);
            this.recordSchema = querySchema;
        }
        catch (SQLException e) {
            log.error(String.format("Failed to create jdbc connection for query %s", query), (Throwable)e);
            throw new CastledRuntimeException(e.getMessage());
        }
    }

    @Override
    public Tuple readRecord() throws Exception {
        if (this.resultSet.next()) {
            return ((PostgresResultSetSchemaMapper)((Object)ObjectRegistry.getInstance(PostgresResultSetSchemaMapper.class))).getRecord(this.resultSet, this.recordSchema);
        }
        return null;
    }

    @Override
    public void close() {
        try {
            this.resultSet.close();
            this.statement.close();
            this.connection.close();
        }
        catch (SQLException e) {
            log.error("Failed to close connection", (Throwable)e);
            throw new CastledRuntimeException(e.getMessage());
        }
    }
}

