/*
 * Decompiled with CFR 0.152.
 */
package io.castled.commons.streams;

import io.castled.commons.streams.FileRecordInputStream;
import io.castled.exceptions.CastledRuntimeException;
import io.castled.schema.IncompatibleValueException;
import io.castled.schema.SchemaMapper;
import io.castled.schema.models.FieldSchema;
import io.castled.schema.models.RecordSchema;
import io.castled.schema.models.Tuple;
import io.castled.utils.StringUtils;
import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.file.Path;
import java.util.Iterator;
import java.util.zip.GZIPInputStream;
import org.apache.commons.csv.CSVFormat;
import org.apache.commons.csv.CSVParser;
import org.apache.commons.csv.CSVRecord;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CsvFileRecordInputStream
implements FileRecordInputStream {
    private static final Logger log = LoggerFactory.getLogger(CsvFileRecordInputStream.class);
    private final Path filePath;
    private final Iterator<CSVRecord> csvRecordIterator;
    private final SchemaMapper schemaMapper;
    private final RecordSchema recordSchema;

    public CsvFileRecordInputStream(Path filePath, SchemaMapper schemaMapper, RecordSchema recordSchema, boolean gzipped) throws IOException {
        this.filePath = filePath;
        this.schemaMapper = schemaMapper;
        this.recordSchema = recordSchema;
        this.csvRecordIterator = gzipped ? new CSVParser((Reader)new BufferedReader(new InputStreamReader(new GZIPInputStream(new FileInputStream(filePath.toFile())))), CSVFormat.RFC4180.withHeader(new String[0]).withSkipHeaderRecord()).iterator() : new CSVParser((Reader)new BufferedReader(new FileReader(filePath.toFile())), CSVFormat.RFC4180.withHeader(new String[0]).withSkipHeaderRecord()).iterator();
    }

    @Override
    public Tuple readRecord() {
        if (!this.csvRecordIterator.hasNext()) {
            return null;
        }
        try {
            CSVRecord csvRecord = this.csvRecordIterator.next();
            Tuple.Builder recordBuilder = Tuple.builder();
            for (FieldSchema fieldSchema : this.recordSchema.getFieldSchemas()) {
                recordBuilder.put(fieldSchema, this.schemaMapper.transformValue((Object)StringUtils.nullIfEmpty((String)csvRecord.get(fieldSchema.getName())), fieldSchema.getSchema()));
            }
            return recordBuilder.build();
        }
        catch (IncompatibleValueException e) {
            log.error("Failed to read csv record in file {}", (Object)this.filePath.toString(), (Object)e);
            throw new CastledRuntimeException((Throwable)e);
        }
    }

    @Override
    public Path getFilePath() {
        return this.filePath;
    }
}

