/*
 * Decompiled with CFR 0.152.
 */
package io.castled.apps.connectors.sendgrid;

import com.google.common.collect.Maps;
import io.castled.apps.connectors.sendgrid.SendgridObject;
import io.castled.apps.connectors.sendgrid.dtos.ContactAttribute;
import io.castled.apps.connectors.sendgrid.dtos.ContactAttributesResponse;
import io.castled.schema.SchemaConstants;
import io.castled.schema.models.RecordSchema;
import io.castled.schema.models.Schema;
import java.util.HashMap;
import java.util.Map;
import java.util.function.BiConsumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SendgridUtils {
    private static final Logger log = LoggerFactory.getLogger(SendgridUtils.class);

    public static RecordSchema getSchema(SendgridObject sendgridObject, ContactAttributesResponse contactAttributes) {
        RecordSchema.Builder schemaBuilder = RecordSchema.builder().name(sendgridObject.getName());
        BiConsumer<ContactAttribute, Boolean> createSchema = (attrRef, isCustomAttr) -> {
            HashMap params = Maps.newHashMap();
            params.put("custom", isCustomAttr);
            schemaBuilder.put(attrRef.getName(), SendgridUtils.getFieldSchema(attrRef), (Map)params);
        };
        contactAttributes.getReservedFields().stream().filter(attrRef -> SendgridUtils.getFieldSchema(attrRef) != null).forEach(attrRef -> createSchema.accept((ContactAttribute)attrRef, false));
        contactAttributes.getCustomFields().stream().filter(attrRef -> SendgridUtils.getFieldSchema(attrRef) != null).forEach(attrRef -> createSchema.accept((ContactAttribute)attrRef, true));
        return schemaBuilder.build();
    }

    public static Schema getFieldSchema(ContactAttribute contactAttribute) {
        switch (contactAttribute.getFieldType()) {
            case "Text": {
                if (contactAttribute.getName().equals("email")) {
                    return SchemaConstants.EMAIL_SCHEMA;
                }
                return SchemaConstants.OPTIONAL_STRING_SCHEMA;
            }
            case "Number": {
                return SchemaConstants.OPTIONAL_LONG_SCHEMA;
            }
            case "Date": {
                return SchemaConstants.DATE_SCHEMA;
            }
        }
        log.warn(String.format("Invalid data type %s", contactAttribute.getFieldType()));
        return null;
    }
}

