/*
 * Decompiled with CFR 0.152.
 */
package io.castled.apps.connectors.sendgrid;

import com.google.inject.Singleton;
import io.castled.apps.connectors.sendgrid.SendgridUpsertError;
import io.castled.commons.errors.CastledError;
import io.castled.commons.errors.errorclassifications.InvalidFieldValueError;
import io.castled.commons.errors.errorclassifications.UnclassifiedError;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

@Singleton
public class SendgridErrorParser {
    public CastledError getPipelineError(SendgridUpsertError sgError) {
        String errorMsg = sgError.getMessage();
        if (errorMsg.contains("error storing")) {
            Pattern regex = Pattern.compile("=[a-zA-Z]+");
            Matcher matcher = regex.matcher(errorMsg);
            String name = "";
            if (matcher.find()) {
                name = matcher.group();
            }
            String type = "";
            if (matcher.find()) {
                type = matcher.group();
            }
            return new InvalidFieldValueError(name, type, sgError.getMessage());
        }
        return new UnclassifiedError(sgError.getMessage());
    }
}

