/*
 * Decompiled with CFR 0.152.
 */
package io.castled.apps.connectors.salesforce.oauth;

import com.google.inject.Inject;
import io.castled.ObjectRegistry;
import io.castled.apps.connectors.salesforce.SalesforceAccessConfig;
import io.castled.apps.connectors.salesforce.client.SFDCAuthClient;
import io.castled.apps.connectors.salesforce.client.dtos.SFDCTokenResponse;
import io.castled.cache.OAuthCache;
import io.castled.oauth.AccessTokenRefresher;
import io.castled.oauth.OAuthClientConfig;
import io.castled.oauth.OAuthDAO;
import io.castled.oauth.OAuthDetails;
import io.castled.pubsub.MessagePublisher;
import io.castled.pubsub.registry.Message;
import io.castled.pubsub.registry.OAuthDetailsUpdatedMessage;
import org.jdbi.v3.core.Jdbi;

public class SalesforceAccessTokenRefresher
implements AccessTokenRefresher<SalesforceAccessConfig> {
    private final OAuthDAO oAuthDAO = (OAuthDAO)((Jdbi)ObjectRegistry.getInstance(Jdbi.class)).onDemand(OAuthDAO.class);
    private final SFDCAuthClient sfdcAuthClient = (SFDCAuthClient)ObjectRegistry.getInstance(SFDCAuthClient.class);
    private final OAuthClientConfig oAuthClientConfig;
    private final OAuthCache oAuthCache;
    private final MessagePublisher messagePublisher;

    @Inject
    public SalesforceAccessTokenRefresher(OAuthClientConfig oAuthClientConfig) {
        this.oAuthClientConfig = oAuthClientConfig;
        this.oAuthCache = (OAuthCache)((Object)ObjectRegistry.getInstance(OAuthCache.class));
        this.messagePublisher = (MessagePublisher)ObjectRegistry.getInstance(MessagePublisher.class);
    }

    @Override
    public SalesforceAccessConfig refreshAccessConfig(Long oAuthToken) {
        OAuthDetails oAuthDetails = (OAuthDetails)this.oAuthCache.getValue(oAuthToken);
        SalesforceAccessConfig currentAccessConfig = (SalesforceAccessConfig)oAuthDetails.getAccessConfig();
        String refreshToken = oAuthDetails.getAccessConfig().getRefreshToken();
        SFDCTokenResponse sfdcTokenResponse = this.sfdcAuthClient.getTokenViaRefreshToken(oAuthDetails.getAccessConfig().getRefreshToken(), this.oAuthClientConfig.getClientId(), this.oAuthClientConfig.getClientSecret());
        SalesforceAccessConfig salesforceAccessConfig = SalesforceAccessConfig.builder().instanceUrl(sfdcTokenResponse.getInstanceUrl()).accessToken(sfdcTokenResponse.getAccessToken()).refreshToken(refreshToken).userName(currentAccessConfig.getUserName()).displayName(currentAccessConfig.getDisplayName()).build();
        this.oAuthDAO.updateAccessConfig(oAuthToken, salesforceAccessConfig);
        this.messagePublisher.publishMessage((Message)new OAuthDetailsUpdatedMessage(oAuthToken));
        return salesforceAccessConfig;
    }
}

