/*
 * Decompiled with CFR 0.152.
 */
package io.castled.apps.connectors.salesforce.client;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.sforce.async.AsyncApiException;
import com.sforce.async.AsyncExceptionCode;
import com.sforce.async.BatchInfo;
import com.sforce.async.BatchInfoList;
import com.sforce.async.BulkConnection;
import com.sforce.async.ContentType;
import com.sforce.async.JobInfo;
import com.sforce.async.OperationEnum;
import com.sforce.async.QueryResultList;
import com.sforce.ws.ConnectorConfig;
import io.castled.ObjectRegistry;
import io.castled.apps.connectors.salesforce.SalesforceAccessConfig;
import io.castled.apps.connectors.salesforce.client.SFDCUtils;
import io.castled.apps.connectors.salesforce.client.dtos.PkChunking;
import io.castled.apps.connectors.salesforce.oauth.SalesforceAccessTokenRefresher;
import io.castled.core.WaitTimeAndRetry;
import io.castled.exceptions.CastledRuntimeException;
import io.castled.functionalinterfaces.ThrowingConsumer;
import io.castled.functionalinterfaces.ThrowingSupplier;
import io.castled.oauth.OAuthClientConfig;
import io.castled.oauth.OAuthDAO;
import io.castled.oauth.OAuthDetails;
import io.castled.utils.JsonStreamParser;
import io.castled.utils.RetryUtils;
import io.castled.utils.ThreadUtils;
import io.castled.utils.TimeUtils;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.TimeoutException;
import org.jdbi.v3.core.Jdbi;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SFDCBulkClient {
    private static final Logger log = LoggerFactory.getLogger(SFDCBulkClient.class);
    private final BulkConnection bulkConnection;
    private final OAuthDetails oAuthDetails;
    private final SalesforceAccessTokenRefresher accessTokenRefresher;

    public SFDCBulkClient(Long oauthToken, OAuthClientConfig oAuthClientConfig) throws Exception {
        OAuthDetails oAuthDetails = ((OAuthDAO)((Jdbi)ObjectRegistry.getInstance(Jdbi.class)).onDemand(OAuthDAO.class)).getOAuthDetails(oauthToken);
        this.bulkConnection = new BulkConnection(this.getConnectorConfig(oAuthDetails));
        this.accessTokenRefresher = new SalesforceAccessTokenRefresher(oAuthClientConfig);
        this.oAuthDetails = oAuthDetails;
    }

    public void runBulkQuery(String query, PkChunking pkChunking, String object, long timeoutMs, ThrowingConsumer<Map<String, Object>> recordConsumer) {
        try {
            JobInfo jobInfo = this.createBulkJob(this.constructJobInfo(object, pkChunking));
            this.createBatchFromStream(jobInfo, new ByteArrayInputStream(query.getBytes()));
            long startTime = System.currentTimeMillis();
            HashSet completedBatches = Sets.newHashSet();
            JsonStreamParser jsonStreamParser = (JsonStreamParser)ObjectRegistry.getInstance(JsonStreamParser.class);
            ThreadUtils.interruptIgnoredSleep((long)TimeUtils.secondsToMillis((long)10L));
            while (true) {
                BatchInfoList batchInfoList = this.getBatchInfoList(jobInfo.getId(), ContentType.JSON);
                block8: for (BatchInfo batchInfo : batchInfoList.getBatchInfo()) {
                    switch (batchInfo.getState()) {
                        case NotProcessed: {
                            completedBatches.add(batchInfo.getId());
                            continue block8;
                        }
                        case InProgress: 
                        case Failed: {
                            if (!Optional.ofNullable(batchInfo.getStateMessage()).filter(message -> message.contains("QUERY_TIMEOUT")).isPresent()) continue block8;
                            throw new AsyncApiException("Query timed out", AsyncExceptionCode.Timeout);
                        }
                        case Completed: {
                            QueryResultList queryResultList = this.getQueryResultList(jobInfo.getId(), batchInfo.getId(), ContentType.JSON);
                            for (String result : queryResultList.getResult()) {
                                jsonStreamParser.parseJsonStream(this.getQueryResultStream(jobInfo.getId(), batchInfo.getId(), result), recordConsumer);
                            }
                            completedBatches.add(batchInfo.getId());
                        }
                    }
                }
                if (completedBatches.size() >= batchInfoList.getBatchInfo().length) {
                    this.closeJob(jobInfo.getId());
                    break;
                }
                if (System.currentTimeMillis() - startTime > timeoutMs) {
                    throw new TimeoutException();
                }
                ThreadUtils.interruptIgnoredSleep((long)TimeUtils.secondsToMillis((long)30L));
            }
        }
        catch (Exception e) {
            log.error("Bulk query run failed for query {} and object {}", new Object[]{query, object, e});
            throw new CastledRuntimeException((Throwable)e);
        }
    }

    private JobInfo constructJobInfo(String object, PkChunking pkChunking) {
        JobInfo jobInfo = new JobInfo();
        jobInfo.setObject(object);
        jobInfo.setContentType(ContentType.JSON);
        if (pkChunking.isEnabled()) {
            this.bulkConnection.addHeader("Sforce-Enable-PKChunking", "chunkSize=" + pkChunking.getChunkSize());
            jobInfo.setOperation(OperationEnum.query);
        } else {
            jobInfo.setOperation(OperationEnum.queryAll);
        }
        return jobInfo;
    }

    private ConnectorConfig getConnectorConfig(OAuthDetails oAuthDetails) {
        ConnectorConfig connectorConfig = new ConnectorConfig();
        connectorConfig.setSessionId(oAuthDetails.getAccessConfig().getAccessToken());
        connectorConfig.setCompression(true);
        connectorConfig.setRestEndpoint(SFDCUtils.getBulkApiEndPoint((SalesforceAccessConfig)oAuthDetails.getAccessConfig()));
        return connectorConfig;
    }

    private JobInfo createBulkJob(JobInfo jobInfo) throws Exception {
        return (JobInfo)this.executeRequest(() -> this.bulkConnection.createJob(jobInfo, ContentType.JSON));
    }

    private BatchInfo createBatchFromStream(JobInfo jobInfo, InputStream inputStream) throws Exception {
        return (BatchInfo)this.executeRequest(() -> this.bulkConnection.createBatchFromStream(jobInfo, inputStream));
    }

    private BatchInfoList getBatchInfoList(String jobId, ContentType contentType) throws Exception {
        return (BatchInfoList)this.executeRequest(() -> this.bulkConnection.getBatchInfoList(jobId, contentType));
    }

    private QueryResultList getQueryResultList(String jobId, String batchId, ContentType contentType) throws Exception {
        return (QueryResultList)this.executeRequest(() -> this.bulkConnection.getQueryResultList(jobId, batchId, contentType));
    }

    private InputStream getQueryResultStream(String jobId, String batchId, String resultId) throws Exception {
        return (InputStream)this.executeRequest(() -> this.bulkConnection.getQueryResultStream(jobId, batchId, resultId));
    }

    private void closeJob(String jobId) throws Exception {
        this.executeRequest(() -> this.bulkConnection.closeJob(jobId));
    }

    private <T> T executeRequest(ThrowingSupplier<T> supplier) throws Exception {
        return (T)RetryUtils.retrySupplier(supplier, (int)1, (List)Lists.newArrayList((Object[])new Class[]{AsyncApiException.class}), (throwable, attempts) -> {
            AsyncApiException asyncApiException = (AsyncApiException)throwable;
            if (asyncApiException.getExceptionCode() == AsyncExceptionCode.InvalidSessionId) {
                this.bulkConnection.getConfig().setSessionId(this.accessTokenRefresher.refreshAccessConfig(this.oAuthDetails.getId()).getAccessToken());
                return new WaitTimeAndRetry(0L, true);
            }
            return new WaitTimeAndRetry(0L, false);
        });
    }
}

