/*
 * Decompiled with CFR 0.152.
 */
package io.castled.apps.connectors.restapi;

import io.castled.ObjectRegistry;
import io.castled.apps.connectors.restapi.ErrorObject;
import io.castled.utils.ResponseUtils;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.ws.rs.client.Client;
import javax.ws.rs.client.Entity;
import javax.ws.rs.core.Response;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RestApiClient {
    private static final Logger log = LoggerFactory.getLogger(RestApiClient.class);
    public static final String BEARER_AUTHENTICATION = "Bearer ";
    private final Client client;
    private final String apiKey;
    private final String apiURL;

    public RestApiClient(String apiURL, String apiKey) {
        this.apiURL = apiURL;
        this.apiKey = apiKey;
        this.client = (Client)ObjectRegistry.getInstance(Client.class);
    }

    public ErrorObject upsertDetails(String propertyName, List<Map<String, Object>> details) {
        ErrorObject errorObject = null;
        try {
            Response response = this.invokeRestAPI(propertyName, details);
            log.info("Response status {}", (Object)response.getStatus());
            if (!ResponseUtils.is2xx((Response)response)) {
                errorObject = (ErrorObject)response.readEntity(ErrorObject.class);
            }
        }
        catch (Exception e) {
            log.error(String.format("Custom API upsert failed for %s %s", this.apiURL, this.apiKey), (Throwable)e);
            errorObject = new ErrorObject("UNCLASSIFIED", e.getMessage());
        }
        return errorObject;
    }

    private Response invokeRestAPI(String propertyName, List<Map<String, Object>> inputDetails) {
        return this.client.target(this.apiURL).request(new String[]{"application/json"}).accept(new String[]{"application/json"}).header("Authorization", (Object)(BEARER_AUTHENTICATION + this.apiKey)).post(Entity.json((Object)this.constructPayload(propertyName, inputDetails)));
    }

    private Object constructPayload(String propertyName, List<Map<String, Object>> inputDetails) {
        if (propertyName != null) {
            HashMap<String, List<Map<String, Object>>> jsonObject = new HashMap<String, List<Map<String, Object>>>();
            jsonObject.put(propertyName, inputDetails);
            return jsonObject;
        }
        return inputDetails;
    }
}

