/*
 * Decompiled with CFR 0.152.
 */
package io.castled.apps.connectors.mixpanel;

import io.castled.ObjectRegistry;
import io.castled.apps.connectors.mixpanel.MixpanelObjectFields;
import io.castled.apps.connectors.mixpanel.dto.EventAndError;
import io.castled.apps.connectors.mixpanel.dto.EventBulkInsertResponse;
import io.castled.apps.connectors.mixpanel.dto.EventInsertFailureRecord;
import io.castled.apps.connectors.mixpanel.dto.GroupProfileAndError;
import io.castled.apps.connectors.mixpanel.dto.ProfileBulkUpdateResponse;
import io.castled.apps.connectors.mixpanel.dto.UserProfileAndError;
import io.castled.exceptions.CastledRuntimeException;
import io.castled.utils.JsonUtils;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Base64;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.ws.rs.BadRequestException;
import javax.ws.rs.client.Client;
import javax.ws.rs.client.Entity;
import javax.ws.rs.core.Form;
import javax.ws.rs.core.MediaType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MixpanelRestClient {
    private static final Logger log = LoggerFactory.getLogger(MixpanelRestClient.class);
    public static final String BASIC_AUTH = "Basic ";
    private final Client client;
    private String projectToken = null;
    private String apiSecret = null;
    public static final String EVENT_URL = "https://api.mixpanel.com/import";
    public static final String USER_PROFILE_URL = "https://api.mixpanel.com/engage#profile-batch-update";
    public static final String GROUP_PROFILE_URL = "https://api.mixpanel.com/groups#group-batch-update";

    public MixpanelRestClient(String projectToken, String apiSecret) {
        this.apiSecret = apiSecret;
        this.projectToken = projectToken;
        this.client = (Client)ObjectRegistry.getInstance(Client.class);
    }

    public List<UserProfileAndError> upsertUserProfileDetails(List<Map<String, Object>> userProfileDetails) {
        ArrayList<UserProfileAndError> userProfileAndErrors = new ArrayList<UserProfileAndError>();
        try {
            ProfileBulkUpdateResponse profileBulkUpdateResponse = this.invokeBulkUserProfileUpsert(userProfileDetails);
            log.info("Userprofile bulk update Response {}", (Object)profileBulkUpdateResponse.getStatus());
            if ("0".equalsIgnoreCase(profileBulkUpdateResponse.getStatus())) {
                this.handleUserProfileUpsertFailure(profileBulkUpdateResponse, userProfileAndErrors, userProfileDetails);
            }
        }
        catch (BadRequestException badRequestException) {
            log.error("Userprofile bulk upsert failed ", (Throwable)badRequestException);
            userProfileAndErrors.addAll(userProfileDetails.stream().map(contact -> new UserProfileAndError((String)contact.get("$" + MixpanelObjectFields.USER_PROFILE_FIELDS.DISTINCT_ID.getFieldName()), Collections.singletonList(badRequestException.getMessage()))).collect(Collectors.toList()));
        }
        catch (Exception e) {
            log.error("Upsert failed", (Throwable)e);
            throw new CastledRuntimeException((Throwable)e);
        }
        return userProfileAndErrors;
    }

    public List<GroupProfileAndError> upsertGroupProfileDetails(List<Map<String, Object>> groupProfileDetails) {
        ArrayList<GroupProfileAndError> groupProfileAndErrors = new ArrayList<GroupProfileAndError>();
        try {
            ProfileBulkUpdateResponse response = this.invokeBulkGroupProfileUpsert(groupProfileDetails);
            log.info("Group profile Response {} " + response.getStatus());
            if ("0".equalsIgnoreCase(response.getStatus())) {
                this.handleGroupProfileUpsertFailure(response, groupProfileAndErrors, groupProfileDetails);
            }
        }
        catch (BadRequestException badRequestException) {
            log.error("Group profile bulk update failed", (Throwable)badRequestException);
            groupProfileAndErrors.addAll(groupProfileDetails.stream().map(contact -> new GroupProfileAndError((String)contact.get("$" + MixpanelObjectFields.GROUP_PROFILE_FIELDS.GROUP_ID.getFieldName()), Collections.singletonList(badRequestException.getMessage()))).collect(Collectors.toList()));
        }
        catch (Exception e) {
            log.error("Group profile bulk update failed", (Throwable)e);
            throw new CastledRuntimeException((Throwable)e);
        }
        return groupProfileAndErrors;
    }

    public List<EventAndError> insertEventDetails(List<Map<String, Object>> userProfileDetails) {
        ArrayList<EventAndError> eventAndErrors = new ArrayList<EventAndError>();
        try {
            EventBulkInsertResponse bulkImportResponse = this.invokeBulkEventInsert(userProfileDetails);
            log.info("Response for Event Bulk inserts {} , Number of events imported {}", (Object)bulkImportResponse.getCode(), (Object)bulkImportResponse.getNum_records_imported());
            if (!"200".equalsIgnoreCase(bulkImportResponse.getCode())) {
                this.handleFailure(bulkImportResponse, eventAndErrors, userProfileDetails);
            }
        }
        catch (BadRequestException badRequestException) {
            log.error("Event bulk insert failed because of BAD REQUEST ", (Throwable)badRequestException);
            eventAndErrors.addAll(userProfileDetails.stream().map(userDetail -> new EventAndError(0, (String)((HashMap)userDetail.get("properties")).get("$" + MixpanelObjectFields.EVENT_FIELDS.INSERT_ID.getFieldName()), Collections.singletonList(badRequestException.getMessage()))).collect(Collectors.toList()));
        }
        catch (Exception e) {
            log.error("Event bulk insert failed : ", (Throwable)e);
            eventAndErrors.addAll(userProfileDetails.stream().map(userDetail -> new EventAndError(0, (String)userDetail.get("$" + MixpanelObjectFields.EVENT_FIELDS.INSERT_ID.getFieldName()), Collections.singletonList(e.getMessage()))).collect(Collectors.toList()));
            throw new CastledRuntimeException((Throwable)e);
        }
        return eventAndErrors;
    }

    private boolean handleUserProfileUpsertFailure(ProfileBulkUpdateResponse profileBulkUpdateResponse, List<UserProfileAndError> groupProfileAndErrors, List<Map<String, Object>> groupProfileDetails) {
        groupProfileAndErrors.addAll(groupProfileDetails.stream().map(event -> new UserProfileAndError((String)event.get("$" + MixpanelObjectFields.USER_PROFILE_FIELDS.DISTINCT_ID.getFieldName()), Collections.singletonList(profileBulkUpdateResponse.getError()))).collect(Collectors.toList()));
        return true;
    }

    private boolean handleGroupProfileUpsertFailure(ProfileBulkUpdateResponse profileBulkUpdateResponse, List<GroupProfileAndError> groupProfileAndErrors, List<Map<String, Object>> groupProfileDetails) {
        groupProfileAndErrors.addAll(groupProfileDetails.stream().map(event -> new GroupProfileAndError((String)event.get("$" + MixpanelObjectFields.GROUP_PROFILE_FIELDS.GROUP_ID.getFieldName()), Collections.singletonList(profileBulkUpdateResponse.getError()))).collect(Collectors.toList()));
        return true;
    }

    private void handleFailure(EventBulkInsertResponse bulkImportResponse, List<EventAndError> eventAndErrorList, List<Map<String, Object>> eventDetails) {
        String code;
        Integer numberOfRecordsSynced = bulkImportResponse.getNum_records_imported();
        Integer failedRecordCount = eventDetails.size() - numberOfRecordsSynced;
        switch (code = bulkImportResponse.getCode()) {
            case "400": {
                this.handleErrorCode400(bulkImportResponse, eventAndErrorList, eventDetails);
            }
            case "401": {
                this.handleErrorCode401(bulkImportResponse, eventAndErrorList, eventDetails);
            }
            case "413": {
                this.handleErrorCode413(bulkImportResponse, eventAndErrorList, eventDetails);
            }
            case "429": {
                this.handleErrorCode429(bulkImportResponse, eventAndErrorList, eventDetails);
            }
        }
    }

    private boolean handleErrorCode413(EventBulkInsertResponse bulkImportResponse, List<EventAndError> eventAndErrorList, List<Map<String, Object>> eventDetails) {
        return true;
    }

    private boolean handleErrorCode429(EventBulkInsertResponse bulkImportResponse, List<EventAndError> eventAndErrorList, List<Map<String, Object>> eventDetails) {
        return true;
    }

    private boolean handleErrorCode401(EventBulkInsertResponse bulkImportResponse, List<EventAndError> eventAndErrorList, List<Map<String, Object>> eventDetails) {
        eventAndErrorList.addAll(eventDetails.stream().map(event -> new EventAndError(0, (String)event.get("$" + (Object)((Object)MixpanelObjectFields.EVENT_FIELDS.INSERT_ID)), Collections.singletonList("Invalid Credentials"))).collect(Collectors.toList()));
        return true;
    }

    private boolean handleErrorCode400(EventBulkInsertResponse bulkImportResponse, List<EventAndError> eventAndErrorList, List<Map<String, Object>> eventDetails) {
        List<EventInsertFailureRecord> failureReasons = bulkImportResponse.getFailed_records();
        Map<Integer, List<EventInsertFailureRecord>> contactIndexToFailureReasonsMap = failureReasons.stream().filter(failureReason -> failureReason.getIndex() != null).collect(Collectors.groupingBy(EventInsertFailureRecord::getIndex));
        eventAndErrorList.addAll(contactIndexToFailureReasonsMap.entrySet().stream().map(failedReason -> new EventAndError((Integer)failedReason.getKey(), (String)((Map)eventDetails.get((Integer)failedReason.getKey())).get("$insert_id"), ((List)failedReason.getValue()).stream().map(EventInsertFailureRecord::getMessage).collect(Collectors.toList()))).collect(Collectors.toList()));
        List failedContacts = eventAndErrorList.stream().map(EventAndError::getIndex).collect(Collectors.toList());
        failedContacts.stream().forEach(index -> eventDetails.remove(index));
        return true;
    }

    private ProfileBulkUpdateResponse invokeBulkUserProfileUpsert(List<Map<String, Object>> userProfileDetails) {
        Form form = new Form();
        form.param("data", JsonUtils.objectToString(userProfileDetails));
        form.param("verbose", "1");
        return (ProfileBulkUpdateResponse)this.client.target(USER_PROFILE_URL).request(new MediaType[]{MediaType.APPLICATION_FORM_URLENCODED_TYPE}).accept(new MediaType[]{MediaType.TEXT_PLAIN_TYPE}).post(Entity.form((Form)form), ProfileBulkUpdateResponse.class);
    }

    private ProfileBulkUpdateResponse invokeBulkGroupProfileUpsert(List<Map<String, Object>> groupProfileDetails) {
        Form form = new Form();
        form.param("data", JsonUtils.objectToString(groupProfileDetails));
        form.param("verbose", "1");
        return (ProfileBulkUpdateResponse)this.client.target(GROUP_PROFILE_URL).request(new MediaType[]{MediaType.APPLICATION_FORM_URLENCODED_TYPE}).accept(new MediaType[]{MediaType.TEXT_PLAIN_TYPE}).post(Entity.form((Form)form), ProfileBulkUpdateResponse.class);
    }

    private EventBulkInsertResponse invokeBulkEventInsert(List<Map<String, Object>> userProfileDetails) {
        return (EventBulkInsertResponse)this.client.target(String.format(EVENT_URL, new Object[0])).queryParam("strict", new Object[]{1}).request(new String[]{"application/json"}).accept(new String[]{"application/json"}).header("Authorization", (Object)this.getBasicHeader()).post(Entity.json(userProfileDetails), EventBulkInsertResponse.class);
    }

    private String getBasicHeader() {
        return BASIC_AUTH + Base64.getEncoder().encodeToString((this.apiSecret + ": ").getBytes(StandardCharsets.UTF_8));
    }
}

