/*
 * Decompiled with CFR 0.152.
 */
package io.castled.apps.connectors.mixpanel;

import io.castled.exceptions.CastledRuntimeException;
import java.util.Arrays;

public enum MixpanelObject {
    EVENT("Event"),
    GROUP_PROFILE("Group Profile"),
    USER_PROFILE("User Profile");

    private final String name;

    private MixpanelObject(String name) {
        this.name = name;
    }

    public static MixpanelObject getObjectByName(String name) {
        return Arrays.stream(MixpanelObject.values()).filter(intercomObject -> intercomObject.getName().equals(name)).findFirst().orElseThrow(() -> new CastledRuntimeException(String.format("Invalid object name %s", name)));
    }

    public String getName() {
        return this.name;
    }
}

