/*
 * Decompiled with CFR 0.152.
 */
package io.castled.apps.connectors.mixpanel;

import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.inject.Singleton;
import io.castled.ObjectRegistry;
import io.castled.apps.connectors.mixpanel.MixpanelAppConfig;
import io.castled.apps.connectors.mixpanel.MixpanelAppSyncConfig;
import io.castled.apps.connectors.mixpanel.MixpanelErrorParser;
import io.castled.apps.connectors.mixpanel.MixpanelObjectFields;
import io.castled.apps.connectors.mixpanel.MixpanelObjectSink;
import io.castled.apps.connectors.mixpanel.MixpanelRestClient;
import io.castled.apps.connectors.mixpanel.dto.GroupProfileAndError;
import io.castled.apps.models.DataSinkRequest;
import io.castled.commons.errors.errorclassifications.UnclassifiedError;
import io.castled.commons.models.MessageSyncStats;
import io.castled.commons.streams.ErrorOutputStream;
import io.castled.core.CastledOffsetListQueue;
import io.castled.schema.models.Field;
import io.castled.schema.models.Message;
import io.castled.schema.models.Tuple;
import io.castled.utils.TimeUtils;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class MixpanelGroupProfileSink
extends MixpanelObjectSink<Message> {
    private static final Logger log = LoggerFactory.getLogger(MixpanelGroupProfileSink.class);
    private final MixpanelRestClient mixpanelRestClient;
    private final MixpanelErrorParser mixpanelErrorParser;
    private final ErrorOutputStream errorOutputStream;
    private final AtomicLong processedRecords = new AtomicLong(0L);
    private long lastProcessedOffset = 0L;
    private final MixpanelAppSyncConfig syncConfig;
    private final CastledOffsetListQueue<Message> requestsBuffer = new CastledOffsetListQueue((Consumer)new UpsertGroupProfileConsumer(), 10, 10, true);

    public MixpanelGroupProfileSink(DataSinkRequest dataSinkRequest) {
        this.mixpanelRestClient = new MixpanelRestClient(((MixpanelAppConfig)dataSinkRequest.getExternalApp().getConfig()).getProjectToken(), ((MixpanelAppConfig)dataSinkRequest.getExternalApp().getConfig()).getApiSecret());
        this.errorOutputStream = dataSinkRequest.getErrorOutputStream();
        this.mixpanelErrorParser = (MixpanelErrorParser)ObjectRegistry.getInstance(MixpanelErrorParser.class);
        this.syncConfig = (MixpanelAppSyncConfig)dataSinkRequest.getAppSyncConfig();
    }

    @Override
    protected void writeRecords(List<Message> messages) {
        try {
            this.requestsBuffer.writePayload((List)Lists.newArrayList(messages), 5, TimeUnit.MINUTES);
        }
        catch (TimeoutException e) {
            log.error("Unable to publish records to records queue", (Throwable)e);
            for (Message record : messages) {
                this.errorOutputStream.writeFailedRecord(record, new UnclassifiedError("Internal error!! Unable to publish records to records queue. Please contact support"));
            }
        }
    }

    private Object getGroupID(Tuple record) {
        return record.getValue(MixpanelObjectFields.GROUP_PROFILE_FIELDS.GROUP_ID.getFieldName());
    }

    private Map<String, Object> constructGroupProfileDetails(Tuple record) {
        HashMap groupProfileInfo = Maps.newHashMap();
        groupProfileInfo.put("$group_key", this.syncConfig.getGroupKey());
        groupProfileInfo.put("$group_id", this.getGroupID(record));
        groupProfileInfo.put("$set", this.constructPropertyMap(record));
        return groupProfileInfo;
    }

    private Map<String, Object> constructPropertyMap(Tuple record) {
        return record.getFields().stream().filter(field -> !this.isMixpanelReservedKeyword(field.getName())).collect(Collectors.toMap(Field::getName, Field::getValue));
    }

    private boolean isMixpanelReservedKeyword(String fieldName) {
        return this.getReservedKeywords().contains(fieldName);
    }

    private List<String> getReservedKeywords() {
        return Lists.newArrayList((Object[])new String[]{"group_id", "group_key"});
    }

    @Override
    public MessageSyncStats getSyncStats() {
        return new MessageSyncStats(this.processedRecords.get(), this.lastProcessedOffset);
    }

    @Override
    public long getMaxBufferedObjects() {
        return 200L;
    }

    @Override
    public void flushRecords() throws Exception {
        super.flushRecords();
        this.requestsBuffer.flush(TimeUtils.minutesToMillis((long)10L));
    }

    private void processBulkGroupProfileUpdate(List<Message> messages) {
        List<GroupProfileAndError> failedRecords = this.mixpanelRestClient.upsertGroupProfileDetails(messages.stream().map(Message::getRecord).map(this::constructGroupProfileDetails).collect(Collectors.toList()));
        Map groupProfileRecordMapper = messages.stream().filter(message -> this.getGroupID(message.getRecord()) != null).collect(Collectors.toMap(message -> this.getGroupID(message.getRecord()), Function.identity()));
        failedRecords.forEach(failedRecord -> failedRecord.getFailureReasons().forEach(failureReason -> this.errorOutputStream.writeFailedRecord((Message)groupProfileRecordMapper.get(failedRecord.getGroupID()), this.mixpanelErrorParser.getPipelineError((String)failureReason))));
        this.processedRecords.addAndGet(messages.size());
        this.lastProcessedOffset = Math.max(this.lastProcessedOffset, ((Message)Iterables.getLast(messages)).getOffset());
    }

    private class UpsertGroupProfileConsumer
    implements Consumer<List<Message>> {
        private UpsertGroupProfileConsumer() {
        }

        @Override
        public void accept(List<Message> messages) {
            if (CollectionUtils.isEmpty(messages)) {
                return;
            }
            MixpanelGroupProfileSink.this.processBulkGroupProfileUpdate(messages);
        }
    }
}

