/*
 * Decompiled with CFR 0.152.
 */
package io.castled.apps.connectors.mixpanel;

import io.castled.apps.DataSink;
import io.castled.apps.connectors.mixpanel.MixpanelAppSyncConfig;
import io.castled.apps.connectors.mixpanel.MixpanelEventSink;
import io.castled.apps.connectors.mixpanel.MixpanelGroupProfileSink;
import io.castled.apps.connectors.mixpanel.MixpanelObject;
import io.castled.apps.connectors.mixpanel.MixpanelObjectSink;
import io.castled.apps.connectors.mixpanel.MixpanelUserProfileSink;
import io.castled.apps.models.DataSinkRequest;
import io.castled.commons.models.AppSyncStats;
import io.castled.exceptions.CastledRuntimeException;
import io.castled.schema.models.Message;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MixpanelDataSink
implements DataSink {
    private static final Logger log = LoggerFactory.getLogger(MixpanelDataSink.class);
    private volatile MixpanelObjectSink<Message> mixedPanelObjectSink;

    @Override
    public void syncRecords(DataSinkRequest dataSinkRequest) throws Exception {
        Message message;
        this.mixedPanelObjectSink = this.getObjectSink(dataSinkRequest);
        log.info("Sync started for mix panel");
        while ((message = dataSinkRequest.getMessageInputStream().readMessage()) != null) {
            this.mixedPanelObjectSink.writeRecord(message);
        }
        this.mixedPanelObjectSink.flushRecords();
    }

    private MixpanelObjectSink<Message> getObjectSink(DataSinkRequest dataSinkRequest) {
        MixpanelObjectSink bufferedObjectSink = null;
        MixpanelObject mixpanelObject = MixpanelObject.getObjectByName(((MixpanelAppSyncConfig)dataSinkRequest.getAppSyncConfig()).getObject().getObjectName());
        switch (mixpanelObject) {
            case USER_PROFILE: {
                bufferedObjectSink = new MixpanelUserProfileSink(dataSinkRequest);
                break;
            }
            case GROUP_PROFILE: {
                bufferedObjectSink = new MixpanelGroupProfileSink(dataSinkRequest);
                break;
            }
            case EVENT: {
                bufferedObjectSink = new MixpanelEventSink(dataSinkRequest);
                break;
            }
            default: {
                throw new CastledRuntimeException(String.format("Invalid object type %s!", mixpanelObject.getName()));
            }
        }
        return bufferedObjectSink;
    }

    @Override
    public AppSyncStats getSyncStats() {
        return Optional.ofNullable(this.mixedPanelObjectSink).map(audienceSinkRef -> this.mixedPanelObjectSink.getSyncStats()).map(statsRef -> new AppSyncStats(statsRef.getRecordsProcessed(), statsRef.getOffset(), 0L)).orElse(new AppSyncStats(0L, 0L, 0L));
    }
}

