/*
 * Decompiled with CFR 0.152.
 */
package io.castled.apps.connectors.mixpanel;

import com.google.common.collect.Lists;
import com.google.inject.Singleton;
import io.castled.ObjectRegistry;
import io.castled.apps.ExternalAppConnector;
import io.castled.apps.ExternalAppType;
import io.castled.apps.connectors.mixpanel.MixpanelAppConfig;
import io.castled.apps.connectors.mixpanel.MixpanelAppSyncConfig;
import io.castled.apps.connectors.mixpanel.MixpanelDataSink;
import io.castled.apps.connectors.mixpanel.MixpanelObject;
import io.castled.apps.connectors.mixpanel.MixpanelObjectFields;
import io.castled.apps.dtos.AppSyncConfigDTO;
import io.castled.apps.models.ExternalAppSchema;
import io.castled.apps.models.GenericSyncObject;
import io.castled.apps.models.PrimaryKeyEligibles;
import io.castled.commons.models.AppSyncMode;
import io.castled.dtos.PipelineConfigDTO;
import io.castled.forms.dtos.FormFieldOption;
import io.castled.models.FieldMapping;
import io.castled.schema.models.RecordSchema;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.ws.rs.BadRequestException;
import org.apache.commons.collections.CollectionUtils;

@Singleton
public class MixpanelAppConnector
implements ExternalAppConnector<MixpanelAppConfig, MixpanelDataSink, MixpanelAppSyncConfig> {
    @Override
    public List<FormFieldOption> getAllObjects(MixpanelAppConfig mixpanelAppConfig, MixpanelAppSyncConfig mixpanelAppSyncConfig) {
        return Arrays.stream(MixpanelObject.values()).map(mixpanelObject -> new FormFieldOption((Object)new GenericSyncObject(mixpanelObject.getName(), ExternalAppType.MIXPANEL), mixpanelObject.getName())).collect(Collectors.toList());
    }

    @Override
    public MixpanelDataSink getDataSink() {
        return (MixpanelDataSink)ObjectRegistry.getInstance(MixpanelDataSink.class);
    }

    @Override
    public ExternalAppSchema getSchema(MixpanelAppConfig config, MixpanelAppSyncConfig mixpanelAppSyncConfig) {
        return new ExternalAppSchema(null, PrimaryKeyEligibles.autoDetect());
    }

    @Override
    public List<AppSyncMode> getSyncModes(MixpanelAppConfig config, MixpanelAppSyncConfig mixpanelAppSyncConfig) {
        String object = mixpanelAppSyncConfig.getObject().getObjectName();
        if (MixpanelObject.EVENT.getName().equalsIgnoreCase(object)) {
            return Lists.newArrayList((Object[])new AppSyncMode[]{AppSyncMode.INSERT});
        }
        if (MixpanelObject.USER_PROFILE.getName().equalsIgnoreCase(object) || MixpanelObject.GROUP_PROFILE.getName().equalsIgnoreCase(object)) {
            return Lists.newArrayList((Object[])new AppSyncMode[]{AppSyncMode.UPSERT});
        }
        return Lists.newArrayList((Object[])new AppSyncMode[]{AppSyncMode.INSERT, AppSyncMode.UPSERT, AppSyncMode.UPDATE});
    }

    @Override
    public Class<MixpanelAppSyncConfig> getMappingConfigType() {
        return MixpanelAppSyncConfig.class;
    }

    @Override
    public Class<MixpanelAppConfig> getAppConfigType() {
        return MixpanelAppConfig.class;
    }

    @Override
    public PipelineConfigDTO validateAndEnrichPipelineConfig(PipelineConfigDTO pipelineConfig) throws BadRequestException {
        MixpanelAppSyncConfig mixpanelAppSyncConfig = (MixpanelAppSyncConfig)pipelineConfig.getAppSyncConfig();
        String objectName = ((MixpanelAppSyncConfig)pipelineConfig.getAppSyncConfig()).getObject().getObjectName();
        if (MixpanelObject.EVENT.getName().equalsIgnoreCase(objectName)) {
            this.enrichPipelineConfigForEventObject(pipelineConfig, mixpanelAppSyncConfig);
        }
        if (MixpanelObject.USER_PROFILE.getName().equalsIgnoreCase(objectName)) {
            this.enrichPipelineConfigForUserProfileObject(pipelineConfig, mixpanelAppSyncConfig);
        }
        if (MixpanelObject.GROUP_PROFILE.getName().equalsIgnoreCase(objectName)) {
            this.enrichPipelineConfigForGroupProfileObject(pipelineConfig, mixpanelAppSyncConfig);
        }
        return pipelineConfig;
    }

    private void enrichPipelineConfigForUserProfileObject(PipelineConfigDTO pipelineConfig, MixpanelAppSyncConfig mixpanelAppSyncConfig) throws BadRequestException {
        String distinctID = Optional.ofNullable(mixpanelAppSyncConfig.getDistinctID()).orElseThrow(() -> new BadRequestException("Column uniquely identifying the User is mandatory"));
        ArrayList additionalMapping = Lists.newArrayList();
        Optional.ofNullable(distinctID).ifPresent(ID -> additionalMapping.add(new FieldMapping((String)ID, MixpanelObjectFields.USER_PROFILE_FIELDS.DISTINCT_ID.getFieldName(), false)));
        Optional.ofNullable(mixpanelAppSyncConfig.getLastName()).ifPresent(lastName -> additionalMapping.add(new FieldMapping((String)lastName, MixpanelObjectFields.USER_PROFILE_FIELDS.LAST_NAME.getFieldName(), false)));
        Optional.ofNullable(mixpanelAppSyncConfig.getFirstName()).ifPresent(firstName -> additionalMapping.add(new FieldMapping((String)firstName, MixpanelObjectFields.USER_PROFILE_FIELDS.FIRST_NAME.getFieldName(), false)));
        Optional.ofNullable(mixpanelAppSyncConfig.getUserEmail()).ifPresent(email -> additionalMapping.add(new FieldMapping((String)email, MixpanelObjectFields.USER_PROFILE_FIELDS.EMAIL.getFieldName(), false)));
        pipelineConfig.getMapping().addAdditionalMappings(additionalMapping);
        pipelineConfig.getMapping().setPrimaryKeys(Collections.singletonList(MixpanelObjectFields.USER_PROFILE_FIELDS.DISTINCT_ID.getFieldName()));
    }

    private void enrichPipelineConfigForGroupProfileObject(PipelineConfigDTO pipelineConfig, MixpanelAppSyncConfig mixpanelAppSyncConfig) throws BadRequestException {
        String groupID = Optional.ofNullable(mixpanelAppSyncConfig.getGroupID()).orElseThrow(() -> new BadRequestException("Column uniquely identifying the Group is mandatory"));
        String groupKey = Optional.ofNullable(mixpanelAppSyncConfig.getGroupKey()).orElseThrow(() -> new BadRequestException("Group key is mandatory"));
        ArrayList additionalMapping = Lists.newArrayList();
        Optional.ofNullable(groupID).ifPresent(ID -> additionalMapping.add(new FieldMapping((String)ID, MixpanelObjectFields.GROUP_PROFILE_FIELDS.GROUP_ID.getFieldName(), false)));
        pipelineConfig.getMapping().addAdditionalMappings(additionalMapping);
        pipelineConfig.getMapping().setPrimaryKeys(Collections.singletonList(MixpanelObjectFields.GROUP_PROFILE_FIELDS.GROUP_ID.getFieldName()));
    }

    private void enrichPipelineConfigForEventObject(PipelineConfigDTO pipelineConfig, MixpanelAppSyncConfig mixpanelAppSyncConfig) throws BadRequestException {
        String eventId = Optional.ofNullable(mixpanelAppSyncConfig.getEventID()).orElseThrow(() -> new BadRequestException("Column uniquely identifying the Event is mandatory"));
        Optional.ofNullable(mixpanelAppSyncConfig.getEventName()).orElseThrow(() -> new BadRequestException("Event Name is mandatory"));
        ArrayList additionalMapping = Lists.newArrayList();
        Optional.ofNullable(eventId).ifPresent(insertID -> additionalMapping.add(new FieldMapping((String)insertID, MixpanelObjectFields.EVENT_FIELDS.INSERT_ID.getFieldName(), false)));
        Optional.ofNullable(mixpanelAppSyncConfig.getDistinctIDForEvent()).ifPresent(distinctID -> additionalMapping.add(new FieldMapping((String)distinctID, MixpanelObjectFields.EVENT_FIELDS.DISTINCT_ID.getFieldName(), false)));
        Optional.ofNullable(mixpanelAppSyncConfig.getEventIP()).ifPresent(eventIP -> additionalMapping.add(new FieldMapping((String)eventIP, MixpanelObjectFields.EVENT_FIELDS.GEO_IP.getFieldName(), false)));
        Optional.ofNullable(mixpanelAppSyncConfig.getEventTimeStamp()).ifPresent(eventTimeStamp -> additionalMapping.add(new FieldMapping((String)eventTimeStamp, MixpanelObjectFields.EVENT_FIELDS.EVENT_TIMESTAMP.getFieldName(), false)));
        pipelineConfig.getMapping().addAdditionalMappings(additionalMapping);
        pipelineConfig.getMapping().setPrimaryKeys(Collections.singletonList(MixpanelObjectFields.EVENT_FIELDS.INSERT_ID.getFieldName()));
    }

    @Override
    public RecordSchema enrichWarehouseASchema(AppSyncConfigDTO appSyncConfigDTO, RecordSchema warehouseSchema) {
        List fieldSchemas;
        List<String> warehouseFieldsToBeRemoved;
        MixpanelAppSyncConfig mixpanelAppSyncConfig = (MixpanelAppSyncConfig)appSyncConfigDTO.getAppSyncConfig();
        String objectName = mixpanelAppSyncConfig.getObject().getObjectName();
        if (MixpanelObject.EVENT.getName().equalsIgnoreCase(objectName)) {
            warehouseFieldsToBeRemoved = this.getAllReservedFieldsForEventProfile(mixpanelAppSyncConfig);
            fieldSchemas = warehouseSchema.getFieldSchemas().stream().filter(schema -> warehouseFieldsToBeRemoved.contains(schema.getName())).collect(Collectors.toList());
            warehouseSchema.removeFieldSchema(fieldSchemas);
        }
        if (MixpanelObject.USER_PROFILE.getName().equalsIgnoreCase(objectName)) {
            warehouseFieldsToBeRemoved = this.getAllReservedFieldsForUserProfile(mixpanelAppSyncConfig);
            fieldSchemas = warehouseSchema.getFieldSchemas().stream().filter(schema -> warehouseFieldsToBeRemoved.contains(schema.getName())).collect(Collectors.toList());
            warehouseSchema.removeFieldSchema(fieldSchemas);
        }
        if (MixpanelObject.GROUP_PROFILE.getName().equalsIgnoreCase(objectName)) {
            warehouseFieldsToBeRemoved = this.getAllReservedFieldsForGroupProfile(mixpanelAppSyncConfig);
            fieldSchemas = warehouseSchema.getFieldSchemas().stream().filter(schema -> warehouseFieldsToBeRemoved.contains(schema.getName())).collect(Collectors.toList());
            warehouseSchema.removeFieldSchema(fieldSchemas);
        }
        return warehouseSchema;
    }

    private List<String> getAllReservedFieldsForUserProfile(MixpanelAppSyncConfig mixpanelAppSyncConfig) {
        ArrayList reservedFields = Lists.newArrayList();
        CollectionUtils.addIgnoreNull((Collection)reservedFields, (Object)mixpanelAppSyncConfig.getDistinctID());
        CollectionUtils.addIgnoreNull((Collection)reservedFields, (Object)mixpanelAppSyncConfig.getFirstName());
        CollectionUtils.addIgnoreNull((Collection)reservedFields, (Object)mixpanelAppSyncConfig.getLastName());
        CollectionUtils.addIgnoreNull((Collection)reservedFields, (Object)mixpanelAppSyncConfig.getUserEmail());
        return reservedFields;
    }

    private List<String> getAllReservedFieldsForGroupProfile(MixpanelAppSyncConfig mixpanelAppSyncConfig) {
        ArrayList reservedFields = Lists.newArrayList();
        CollectionUtils.addIgnoreNull((Collection)reservedFields, (Object)mixpanelAppSyncConfig.getGroupID());
        CollectionUtils.addIgnoreNull((Collection)reservedFields, (Object)mixpanelAppSyncConfig.getGroupKey());
        return reservedFields;
    }

    private List<String> getAllReservedFieldsForEventProfile(MixpanelAppSyncConfig mixpanelAppSyncConfig) {
        ArrayList reservedFields = Lists.newArrayList();
        CollectionUtils.addIgnoreNull((Collection)reservedFields, (Object)mixpanelAppSyncConfig.getEventID());
        CollectionUtils.addIgnoreNull((Collection)reservedFields, (Object)mixpanelAppSyncConfig.getEventIP());
        CollectionUtils.addIgnoreNull((Collection)reservedFields, (Object)mixpanelAppSyncConfig.getEventName());
        CollectionUtils.addIgnoreNull((Collection)reservedFields, (Object)mixpanelAppSyncConfig.getEventTimeStamp());
        CollectionUtils.addIgnoreNull((Collection)reservedFields, (Object)mixpanelAppSyncConfig.getDistinctIDForEvent());
        return reservedFields;
    }
}

