/*
 * Decompiled with CFR 0.152.
 */
package io.castled.apps.connectors.marketo;

import com.google.common.collect.Maps;
import io.castled.apps.connectors.marketo.MarketoObject;
import io.castled.apps.connectors.marketo.dtos.GenericAttribute;
import io.castled.schema.SchemaConstants;
import io.castled.schema.models.RecordSchema;
import io.castled.schema.models.Schema;
import io.castled.schema.models.SchemaType;
import java.time.LocalDate;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.function.BiConsumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MarketoUtils {
    private static final Logger log = LoggerFactory.getLogger(MarketoUtils.class);

    public static RecordSchema getSchema(MarketoObject marketoObject, List<GenericAttribute> attributes, Map<String, String> dedupeAttrsFieldMap) {
        RecordSchema.Builder schemaBuilder = RecordSchema.builder().name(marketoObject.getName());
        BiConsumer<GenericAttribute, MarketoObject> createSchema = (attrRef, objectRef) -> {
            HashMap params = Maps.newHashMap();
            if (objectRef == MarketoObject.LEADS) {
                params.put("name", attrRef.getRest().getName());
            } else {
                params.put("name", attrRef.getName());
                params.put("fieldName", dedupeAttrsFieldMap.get(attrRef.getName()));
            }
            schemaBuilder.put(attrRef.getDisplayName(), MarketoUtils.getFieldSchema(attrRef.getDataType()), (Map)params);
        };
        attributes.stream().forEach(attrRef -> createSchema.accept((GenericAttribute)attrRef, marketoObject));
        return schemaBuilder.build();
    }

    public static Schema getFieldSchema(String dataType) {
        switch (dataType) {
            case "string": 
            case "text": 
            case "url": 
            case "reference": 
            case "currency": 
            case "phone": {
                return SchemaConstants.OPTIONAL_STRING_SCHEMA;
            }
            case "email": {
                return SchemaConstants.OPTIONAL_EMAIL_SCHEMA;
            }
            case "boolean": {
                return SchemaConstants.OPTIONAL_BOOL_SCHEMA;
            }
            case "integer": {
                return SchemaConstants.OPTIONAL_LONG_SCHEMA;
            }
            case "float": {
                return SchemaConstants.OPTIONAL_FLOAT_SCHEMA;
            }
            case "date": {
                return SchemaConstants.OPTIONAL_DATE_SCHEMA;
            }
            case "datetime": {
                return SchemaConstants.OPTIONAL_ZONED_TIMESTAMP_SCHEMA;
            }
        }
        log.warn(String.format("Invalid data type %s", dataType));
        return null;
    }

    public static Object formatValue(Object value, Schema schema) {
        if (value == null) {
            return null;
        }
        if (schema.getType() == SchemaType.DATE) {
            return DateTimeFormatter.ofPattern("yyyy-MM-dd", Locale.ENGLISH).format((LocalDate)value);
        }
        if (schema.getType() == SchemaType.ZONED_TIMESTAMP) {
            return ((ZonedDateTime)value).format(DateTimeFormatter.ISO_OFFSET_DATE_TIME);
        }
        return value;
    }
}

