/*
 * Decompiled with CFR 0.152.
 */
package io.castled.apps.connectors.marketo;

import com.google.api.client.util.Lists;
import io.castled.ObjectRegistry;
import io.castled.apps.connectors.marketo.BatchSyncStats;
import io.castled.apps.connectors.marketo.MarketoAppConfig;
import io.castled.apps.connectors.marketo.MarketoAuthClient;
import io.castled.apps.connectors.marketo.MarketoObject;
import io.castled.apps.connectors.marketo.MarketoSyncError;
import io.castled.apps.connectors.marketo.ObjectAttributesContainer;
import io.castled.apps.connectors.marketo.dtos.BatchLeadUpdateRequest;
import io.castled.apps.connectors.marketo.dtos.BatchSyncRequestResponse;
import io.castled.apps.connectors.marketo.dtos.BatchSyncResult;
import io.castled.apps.connectors.marketo.dtos.BulkRequestStatusResponse;
import io.castled.apps.connectors.marketo.dtos.BulkResult;
import io.castled.apps.connectors.marketo.dtos.BulkSyncRequestResponse;
import io.castled.apps.connectors.marketo.dtos.BulkSyncRequestStatus;
import io.castled.apps.connectors.marketo.dtos.ErrorResponse;
import io.castled.apps.connectors.marketo.dtos.GenericAttribute;
import io.castled.apps.connectors.marketo.dtos.GenericAttributesResponse;
import io.castled.apps.connectors.marketo.dtos.GenericAttributesWrapper;
import io.castled.apps.connectors.marketo.dtos.GenericObjectSyncRequest;
import io.castled.apps.connectors.marketo.dtos.LeadAttributesResponse;
import io.castled.apps.connectors.marketo.exception.TokenExpiredException;
import io.castled.core.WaitTimeAndRetry;
import io.castled.exceptions.CastledRuntimeException;
import io.castled.functionalinterfaces.ThrowingConsumer;
import io.castled.functionalinterfaces.ThrowingSupplier;
import io.castled.utils.JsonUtils;
import io.castled.utils.RetryUtils;
import io.castled.utils.ThreadUtils;
import io.castled.utils.TimeUtils;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import javax.ws.rs.client.Client;
import javax.ws.rs.client.Entity;
import javax.ws.rs.core.MediaType;
import org.glassfish.jersey.media.multipart.BodyPart;
import org.glassfish.jersey.media.multipart.Boundary;
import org.glassfish.jersey.media.multipart.FormDataMultiPart;
import org.glassfish.jersey.media.multipart.file.StreamDataBodyPart;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MarketoBulkClient {
    private static final Logger log = LoggerFactory.getLogger(MarketoBulkClient.class);
    private final MarketoAppConfig appConfig;
    private final MarketoAuthClient authClient;
    private final Client client;
    private static final String OBJECT_NOT_FOUND = "1013";
    private static final String OBJECT_FOUND = "1017";
    private static final String ERROR_NOT_FOUND = "1004";
    private static final String ERROR_FOUND = "1005";
    private static final String[] WHITE_LIST_ERRORS = new String[]{"1013", "1017", "1004", "1005"};
    private Predicate<BatchSyncResult> isRecordSyncFailed = result -> "failed".equals(result.getStatus()) || "skipped".equals(result.getStatus()) && Arrays.stream(WHITE_LIST_ERRORS).noneMatch(error -> error.equals(((ErrorResponse)result.getReasons().stream().findFirst().get()).getCode()));
    private Predicate<BatchSyncResult> isRecordSyncSkipped = result -> "skipped".equals(result.getStatus()) && Arrays.stream(WHITE_LIST_ERRORS).anyMatch(error -> error.equals(((ErrorResponse)result.getReasons().stream().findFirst().get()).getCode()));
    private ThrowingConsumer<List<ErrorResponse>> errorConsumer = errors -> {
        ErrorResponse err = (ErrorResponse)errors.stream().findFirst().get();
        switch (err.getCode()) {
            case "602": {
                throw new TokenExpiredException(err);
            }
        }
    };

    public MarketoBulkClient(MarketoAppConfig appConfig) {
        this.appConfig = appConfig;
        this.authClient = new MarketoAuthClient(appConfig);
        this.client = (Client)ObjectRegistry.getInstance(Client.class);
    }

    public ObjectAttributesContainer getAttributes(MarketoObject object) {
        ObjectAttributesContainer attrsContainer;
        String url = String.format("%s/rest/v1/%s/describe.json", this.appConfig.getBaseUrl(), object.getName());
        if (object == MarketoObject.LEADS) {
            LeadAttributesResponse response = (LeadAttributesResponse)this.client.target(url).request(new String[]{"application/json"}).header("Authorization", (Object)("Bearer " + this.authClient.getToken())).get(LeadAttributesResponse.class);
            List<GenericAttribute> result = response.getResult();
            List<String> primaryKeys = response.getResult().stream().map(attrRef -> attrRef.getRest().getName()).filter(fieldName -> !fieldName.equals("id")).collect(Collectors.toList());
            attrsContainer = new ObjectAttributesContainer(result, primaryKeys, "id", object);
        } else {
            GenericAttributesResponse response = (GenericAttributesResponse)this.client.target(url).request(new String[]{"application/json"}).header("Authorization", (Object)("Bearer " + this.authClient.getToken())).get(GenericAttributesResponse.class);
            GenericAttributesWrapper wrapper = (GenericAttributesWrapper)response.getResult().stream().findFirst().get();
            attrsContainer = new ObjectAttributesContainer(wrapper.getFields(), wrapper.getDedupeFields(), wrapper.getIdField(), object);
        }
        return attrsContainer;
    }

    public BatchSyncStats batchSyncObject(MarketoObject object, GenericObjectSyncRequest request) {
        String url = String.format("%s/rest/v1/%s.json", this.appConfig.getBaseUrl(), object.getName());
        ThrowingSupplier requestSupplier = () -> {
            BatchSyncRequestResponse response = (BatchSyncRequestResponse)this.client.target(url).request(new String[]{"application/json"}).header("Authorization", (Object)("Bearer " + this.authClient.getToken())).post(Entity.json((Object)request), BatchSyncRequestResponse.class);
            if (!response.getSuccess().booleanValue()) {
                this.errorConsumer.accept(response.getErrors());
            }
            return response;
        };
        BatchSyncRequestResponse response = (BatchSyncRequestResponse)this.executeRequest(requestSupplier);
        ArrayList marketoErrors = Lists.newArrayList();
        long skippedCount = 0L;
        if (!response.getSuccess().booleanValue()) {
            ErrorResponse err = (ErrorResponse)response.getErrors().stream().findFirst().get();
            IntStream.rangeClosed(0, request.getInput().size()).forEach(i -> marketoErrors.add(new MarketoSyncError(i, err.getCode(), err.getMessage())));
        } else {
            response.getResult().stream().filter(this.isRecordSyncFailed).forEach(resultRef -> marketoErrors.add(new MarketoSyncError(resultRef.getSeq(), ((ErrorResponse)resultRef.getReasons().stream().findFirst().get()).getCode(), ((ErrorResponse)resultRef.getReasons().stream().findFirst().get()).getMessage())));
            skippedCount = response.getResult().stream().filter(this.isRecordSyncSkipped).count();
        }
        return new BatchSyncStats(skippedCount, marketoErrors);
    }

    public BatchSyncStats batchUpdateLeads(BatchLeadUpdateRequest request) {
        String url = String.format("%s/rest/v1/leads.json", this.appConfig.getBaseUrl());
        ThrowingSupplier requestSupplier = () -> {
            BatchSyncRequestResponse response = (BatchSyncRequestResponse)this.client.target(url).request(new String[]{"application/json"}).header("Authorization", (Object)("Bearer " + this.authClient.getToken())).post(Entity.json((Object)request), BatchSyncRequestResponse.class);
            if (!response.getSuccess().booleanValue()) {
                this.errorConsumer.accept(response.getErrors());
            }
            return response;
        };
        BatchSyncRequestResponse response = (BatchSyncRequestResponse)this.executeRequest(requestSupplier);
        ArrayList marketoErrors = Lists.newArrayList();
        long skippedCount = 0L;
        if (!response.getSuccess().booleanValue()) {
            ErrorResponse err = (ErrorResponse)response.getErrors().stream().findFirst().get();
            IntStream.rangeClosed(0, request.getInput().size()).forEach(i -> marketoErrors.add(new MarketoSyncError(i, err.getCode(), err.getMessage())));
        } else {
            List<BatchSyncResult> results = response.getResult();
            IntStream.range(0, results.size()).filter(i -> this.isRecordSyncFailed.test((BatchSyncResult)results.get(i))).forEach(i -> marketoErrors.add(new MarketoSyncError(i, ((ErrorResponse)((BatchSyncResult)results.get(i)).getReasons().stream().findFirst().get()).getCode(), ((ErrorResponse)((BatchSyncResult)results.get(i)).getReasons().stream().findFirst().get()).getMessage())));
            skippedCount = results.stream().filter(this.isRecordSyncSkipped).count();
        }
        return new BatchSyncStats(skippedCount, marketoErrors);
    }

    List<MarketoSyncError> bulkUploadLeads(ByteArrayOutputStream leadStream, String primaryKey, Integer msgCount) {
        ArrayList marketoErrors = Lists.newArrayList();
        MediaType TEXT_CSV_TYPE = new MediaType("text", "csv");
        StreamDataBodyPart streamDataBodyPart = new StreamDataBodyPart("file", (InputStream)new ByteArrayInputStream(leadStream.toByteArray()), "leads.csv", TEXT_CSV_TYPE);
        FormDataMultiPart formDataMultiPart = new FormDataMultiPart();
        formDataMultiPart.field("format", "csv");
        if (primaryKey != null) {
            formDataMultiPart.field("lookupField", primaryKey);
        }
        formDataMultiPart.bodyPart((BodyPart)streamDataBodyPart);
        String url = String.format("%s/bulk/v1/leads.json", this.appConfig.getBaseUrl());
        ThrowingSupplier requestSupplier = () -> {
            BulkSyncRequestResponse response = (BulkSyncRequestResponse)this.client.target(url).request(new String[]{"application/json"}).header("Authorization", (Object)("Bearer " + this.authClient.getToken())).post(Entity.entity((Object)formDataMultiPart, (MediaType)Boundary.addBoundary((MediaType)formDataMultiPart.getMediaType())), BulkSyncRequestResponse.class);
            if (!response.getSuccess().booleanValue()) {
                this.errorConsumer.accept(response.getErrors());
            }
            return response;
        };
        BulkSyncRequestResponse response = (BulkSyncRequestResponse)this.executeRequest(requestSupplier);
        BulkSyncRequestStatus status = null;
        do {
            ThreadUtils.interruptIgnoredSleep((long)TimeUtils.secondsToMillis((long)5L));
            status = this.getBulkRequestStatus(response);
            System.out.println(JsonUtils.objectToString((Object)status));
        } while ("Queued".equals(status.getStatus()) || "Importing".equals(status.getStatus()));
        if (!response.getSuccess().booleanValue() || "Failed".equals(status.getStatus())) {
            ErrorResponse err = (ErrorResponse)response.getErrors().stream().findFirst().get();
            IntStream.rangeClosed(0, msgCount).forEach(i -> marketoErrors.add(new MarketoSyncError(i, err.getCode(), err.getMessage())));
        } else if (status.getNumOfRowsFailed() > 0) {
            // empty if block
        }
        return marketoErrors;
    }

    private BulkSyncRequestStatus getBulkRequestStatus(BulkSyncRequestResponse res) {
        BulkResult result = (BulkResult)res.getResult().stream().findFirst().get();
        String url = String.format("%s/bulk/v1/leads/batch/%s.json", this.appConfig.getBaseUrl(), result.getBatchId());
        ThrowingSupplier requestSupplier = () -> {
            BulkRequestStatusResponse response = (BulkRequestStatusResponse)this.client.target(url).request(new String[]{"application/json"}).header("Authorization", (Object)("Bearer " + this.authClient.getToken())).get(BulkRequestStatusResponse.class);
            if (!response.getSuccess().booleanValue()) {
                this.errorConsumer.accept(response.getErrors());
            }
            return response;
        };
        BulkRequestStatusResponse response = (BulkRequestStatusResponse)this.executeRequest(requestSupplier);
        return (BulkSyncRequestStatus)response.getResult().stream().findFirst().get();
    }

    private <T> T executeRequest(ThrowingSupplier<T> supplier) {
        try {
            return (T)RetryUtils.retrySupplier(supplier, (int)1, Arrays.asList(TokenExpiredException.class), (throwable, attempts) -> {
                if (throwable instanceof TokenExpiredException && attempts <= 1) {
                    return new WaitTimeAndRetry(0L, true);
                }
                return new WaitTimeAndRetry(0L, false);
            });
        }
        catch (Exception e) {
            throw new CastledRuntimeException((Throwable)e);
        }
    }
}

