/*
 * Decompiled with CFR 0.152.
 */
package io.castled.apps.connectors.marketo;

import com.google.common.hash.Hashing;
import com.google.inject.Singleton;
import io.castled.ObjectRegistry;
import io.castled.apps.connectors.marketo.MarketoAppConfig;
import io.castled.apps.connectors.marketo.dtos.MarketoTokenResponse;
import io.castled.utils.GenericKeyValueStore;
import io.castled.utils.StringUtils;
import java.nio.charset.StandardCharsets;
import javax.ws.rs.client.Client;

@Singleton
public class MarketoAuthClient {
    private final Client client;
    private final MarketoAppConfig appConfig;
    private final String MARKETO_NS = "marketo:";
    private final GenericKeyValueStore tokenStore;

    public MarketoAuthClient(MarketoAppConfig appConfig) {
        this.appConfig = appConfig;
        this.client = (Client)ObjectRegistry.getInstance(Client.class);
        this.tokenStore = (GenericKeyValueStore)ObjectRegistry.getInstance(GenericKeyValueStore.class);
    }

    public String getTokenViaRefreshToken() {
        String TOKEN_SERVICE_END_POINT = String.format("%s/identity/oauth/token", this.appConfig.getBaseUrl());
        MarketoTokenResponse response = (MarketoTokenResponse)this.client.target(TOKEN_SERVICE_END_POINT).queryParam("grant_type", new Object[]{"client_credentials"}).queryParam("client_id", new Object[]{this.appConfig.getClientId()}).queryParam("client_secret", new Object[]{this.appConfig.getClientSecret()}).request(new String[]{"application/json"}).get(MarketoTokenResponse.class);
        this.tokenStore.putKey("marketo:", this.getTokenKey(), response.getExpiresIn().intValue(), response.getAccessToken());
        return response.getAccessToken();
    }

    public String getToken() {
        String accessToken = this.tokenStore.getKey("marketo:", this.getTokenKey());
        if (StringUtils.isEmpty((String)accessToken)) {
            return this.getTokenViaRefreshToken();
        }
        return accessToken;
    }

    private String getTokenKey() {
        String sha256hex = Hashing.sha256().hashString((CharSequence)(this.appConfig.getClientId() + this.appConfig.getClientSecret()), StandardCharsets.UTF_8).toString();
        return sha256hex;
    }
}

