/*
 * Decompiled with CFR 0.152.
 */
package io.castled.apps.connectors.mailchimp.client;

import com.google.inject.Inject;
import com.google.inject.Singleton;
import io.castled.apps.connectors.mailchimp.client.dtos.MailChimpTokenResponse;
import io.castled.apps.connectors.mailchimp.client.dtos.MailchimpMetadataResponse;
import javax.ws.rs.client.Client;
import javax.ws.rs.client.Entity;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class MailchimpAuthClient {
    private static final Logger log = LoggerFactory.getLogger(MailchimpAuthClient.class);
    private final Client client;
    private static final String TOKEN_SERVICE_END_POINT = "https://login.mailchimp.com/oauth2/token";
    private static final String METADATA_END_POINT = "https://login.mailchimp.com/oauth2/metadata";
    private static final String TOKEN_REQUEST_FORM = "grant_type=authorization_code&client_id=%s&client_secret=%s&redirect_uri=%s&code=%s";

    @Inject
    public MailchimpAuthClient(Client client) {
        this.client = client;
    }

    public String getTokenViaAuthorizationCode(String authorizationCode, String clientId, String clientSecret, String redirectUri) {
        String payload = String.format(TOKEN_REQUEST_FORM, clientId, clientSecret, redirectUri, authorizationCode);
        Response response = this.client.target(TOKEN_SERVICE_END_POINT).request(new String[]{"application/json"}).post(Entity.entity((Object)payload, (MediaType)MediaType.APPLICATION_FORM_URLENCODED_TYPE));
        return ((MailChimpTokenResponse)response.readEntity(MailChimpTokenResponse.class)).getAccessToken();
    }

    public MailchimpMetadataResponse getAccountMetadata(String accessToken) {
        Response response = this.client.target(METADATA_END_POINT).request(new String[]{"application/json"}).header("Authorization", (Object)("Bearer " + accessToken)).get();
        return (MailchimpMetadataResponse)response.readEntity(MailchimpMetadataResponse.class);
    }
}

