/*
 * Decompiled with CFR 0.152.
 */
package io.castled.apps.connectors.mailchimp;

import com.google.inject.Inject;
import io.castled.ObjectRegistry;
import io.castled.apps.connectors.mailchimp.MailchimpAccessConfig;
import io.castled.apps.connectors.mailchimp.client.MailchimpAuthClient;
import io.castled.apps.connectors.mailchimp.client.dtos.MailchimpMetadataResponse;
import io.castled.oauth.BaseOauthAccessProvider;
import io.castled.oauth.OAuthAccessConfig;
import io.castled.oauth.OAuthClientConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MailchimpOAuthAccessProvider
extends BaseOauthAccessProvider {
    private static final Logger log = LoggerFactory.getLogger(MailchimpOAuthAccessProvider.class);
    private static final String AUTHORIZATION_END_POINT = "https://login.mailchimp.com/oauth2/authorize";
    private final MailchimpAuthClient mailchimpAuthClient = (MailchimpAuthClient)ObjectRegistry.getInstance(MailchimpAuthClient.class);
    private final OAuthClientConfig oAuthClientConfig;

    @Inject
    public MailchimpOAuthAccessProvider(OAuthClientConfig oAuthClientConfig) {
        this.oAuthClientConfig = oAuthClientConfig;
    }

    @Override
    public String getAuthorizationUrl(String stateId, String redirectUri, String clientId) {
        return String.format("%s?response_type=code&client_id=%s&redirect_uri=%s&state=%s", AUTHORIZATION_END_POINT, clientId, redirectUri, stateId);
    }

    @Override
    public OAuthAccessConfig getAccessConfig(String authorizationCode, String redirectUri) {
        String accessToken = this.mailchimpAuthClient.getTokenViaAuthorizationCode(authorizationCode, this.oAuthClientConfig.getClientId(), this.oAuthClientConfig.getClientSecret(), redirectUri);
        MailchimpMetadataResponse metadata = this.mailchimpAuthClient.getAccountMetadata(accessToken);
        return MailchimpAccessConfig.builder().accessToken(accessToken).datacenter(metadata.getDc()).loginEmail(metadata.getLoginEmail()).apiEndPoint(metadata.getApiEndpoint()).build();
    }
}

