/*
 * Decompiled with CFR 0.152.
 */
package io.castled.apps.connectors.mailchimp;

import io.castled.oauth.OAuthAccessConfig;
import io.castled.oauth.OAuthServiceType;

public class MailchimpAccessConfig
extends OAuthAccessConfig {
    private String datacenter;
    private String loginEmail;
    private String apiEndPoint;

    public MailchimpAccessConfig(String accessToken, String datacenter, String loginEmail, String apiEndPoint) {
        super(OAuthServiceType.MAILCHIMP, accessToken, null);
        this.datacenter = datacenter;
        this.loginEmail = loginEmail;
        this.apiEndPoint = apiEndPoint;
    }

    public static MailchimpAccessConfigBuilder builder() {
        return new MailchimpAccessConfigBuilder();
    }

    public String getDatacenter() {
        return this.datacenter;
    }

    public String getLoginEmail() {
        return this.loginEmail;
    }

    public String getApiEndPoint() {
        return this.apiEndPoint;
    }

    public MailchimpAccessConfig() {
    }

    public static class MailchimpAccessConfigBuilder {
        private String accessToken;
        private String datacenter;
        private String loginEmail;
        private String apiEndPoint;

        MailchimpAccessConfigBuilder() {
        }

        public MailchimpAccessConfigBuilder accessToken(String accessToken) {
            this.accessToken = accessToken;
            return this;
        }

        public MailchimpAccessConfigBuilder datacenter(String datacenter) {
            this.datacenter = datacenter;
            return this;
        }

        public MailchimpAccessConfigBuilder loginEmail(String loginEmail) {
            this.loginEmail = loginEmail;
            return this;
        }

        public MailchimpAccessConfigBuilder apiEndPoint(String apiEndPoint) {
            this.apiEndPoint = apiEndPoint;
            return this;
        }

        public MailchimpAccessConfig build() {
            return new MailchimpAccessConfig(this.accessToken, this.datacenter, this.loginEmail, this.apiEndPoint);
        }

        public String toString() {
            return "MailchimpAccessConfig.MailchimpAccessConfigBuilder(accessToken=" + this.accessToken + ", datacenter=" + this.datacenter + ", loginEmail=" + this.loginEmail + ", apiEndPoint=" + this.apiEndPoint + ")";
        }
    }
}

