/*
 * Decompiled with CFR 0.152.
 */
package io.castled.apps.connectors.hubspot.client.dtos;

import com.google.common.collect.Lists;
import io.castled.apps.connectors.hubspot.client.dtos.ColumnMapping;
import io.castled.apps.connectors.hubspot.client.dtos.DateFormat;
import io.castled.apps.connectors.hubspot.client.dtos.FileFormat;
import java.util.List;

public class FileImportRequest {
    private String name;
    private List<File> files;

    public FileImportRequest(String name, String fileName, FileFormat fileFormat, DateFormat dateFormat, boolean hasHeader, List<ColumnMapping> columnMappings) {
        this.name = name;
        this.files = Lists.newArrayList((Object[])new File[]{new File(fileName, fileFormat, dateFormat, new FileImportPage(hasHeader, columnMappings))});
    }

    public static FileImportRequestBuilder builder() {
        return new FileImportRequestBuilder();
    }

    public String getName() {
        return this.name;
    }

    public List<File> getFiles() {
        return this.files;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setFiles(List<File> files) {
        this.files = files;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof FileImportRequest)) {
            return false;
        }
        FileImportRequest other = (FileImportRequest)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        List<File> this$files = this.getFiles();
        List<File> other$files = other.getFiles();
        return !(this$files == null ? other$files != null : !((Object)this$files).equals(other$files));
    }

    protected boolean canEqual(Object other) {
        return other instanceof FileImportRequest;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        List<File> $files = this.getFiles();
        result = result * 59 + ($files == null ? 43 : ((Object)$files).hashCode());
        return result;
    }

    public String toString() {
        return "FileImportRequest(name=" + this.getName() + ", files=" + this.getFiles() + ")";
    }

    public FileImportRequest() {
    }

    public static class FileImportRequestBuilder {
        private String name;
        private String fileName;
        private FileFormat fileFormat;
        private DateFormat dateFormat;
        private boolean hasHeader;
        private List<ColumnMapping> columnMappings;

        FileImportRequestBuilder() {
        }

        public FileImportRequestBuilder name(String name) {
            this.name = name;
            return this;
        }

        public FileImportRequestBuilder fileName(String fileName) {
            this.fileName = fileName;
            return this;
        }

        public FileImportRequestBuilder fileFormat(FileFormat fileFormat) {
            this.fileFormat = fileFormat;
            return this;
        }

        public FileImportRequestBuilder dateFormat(DateFormat dateFormat) {
            this.dateFormat = dateFormat;
            return this;
        }

        public FileImportRequestBuilder hasHeader(boolean hasHeader) {
            this.hasHeader = hasHeader;
            return this;
        }

        public FileImportRequestBuilder columnMappings(List<ColumnMapping> columnMappings) {
            this.columnMappings = columnMappings;
            return this;
        }

        public FileImportRequest build() {
            return new FileImportRequest(this.name, this.fileName, this.fileFormat, this.dateFormat, this.hasHeader, this.columnMappings);
        }

        public String toString() {
            return "FileImportRequest.FileImportRequestBuilder(name=" + this.name + ", fileName=" + this.fileName + ", fileFormat=" + (Object)((Object)this.fileFormat) + ", dateFormat=" + (Object)((Object)this.dateFormat) + ", hasHeader=" + this.hasHeader + ", columnMappings=" + this.columnMappings + ")";
        }
    }

    private static class FileImportPage {
        private boolean hasHeader;
        private List<ColumnMapping> columnMappings;

        public boolean isHasHeader() {
            return this.hasHeader;
        }

        public List<ColumnMapping> getColumnMappings() {
            return this.columnMappings;
        }

        public void setHasHeader(boolean hasHeader) {
            this.hasHeader = hasHeader;
        }

        public void setColumnMappings(List<ColumnMapping> columnMappings) {
            this.columnMappings = columnMappings;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof FileImportPage)) {
                return false;
            }
            FileImportPage other = (FileImportPage)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (this.isHasHeader() != other.isHasHeader()) {
                return false;
            }
            List<ColumnMapping> this$columnMappings = this.getColumnMappings();
            List<ColumnMapping> other$columnMappings = other.getColumnMappings();
            return !(this$columnMappings == null ? other$columnMappings != null : !((Object)this$columnMappings).equals(other$columnMappings));
        }

        protected boolean canEqual(Object other) {
            return other instanceof FileImportPage;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + (this.isHasHeader() ? 79 : 97);
            List<ColumnMapping> $columnMappings = this.getColumnMappings();
            result = result * 59 + ($columnMappings == null ? 43 : ((Object)$columnMappings).hashCode());
            return result;
        }

        public String toString() {
            return "FileImportRequest.FileImportPage(hasHeader=" + this.isHasHeader() + ", columnMappings=" + this.getColumnMappings() + ")";
        }

        public FileImportPage(boolean hasHeader, List<ColumnMapping> columnMappings) {
            this.hasHeader = hasHeader;
            this.columnMappings = columnMappings;
        }

        public FileImportPage() {
        }
    }

    private static class File {
        private String fileName;
        private FileFormat fileFormat;
        private DateFormat dateFormat;
        private FileImportPage fileImportPage;

        public File(String fileName, FileFormat fileFormat, DateFormat dateFormat, FileImportPage fileImportPage) {
            this.fileName = fileName;
            this.fileFormat = fileFormat;
            this.dateFormat = dateFormat;
            this.fileImportPage = fileImportPage;
        }

        public File() {
        }

        public String getFileName() {
            return this.fileName;
        }

        public FileFormat getFileFormat() {
            return this.fileFormat;
        }

        public DateFormat getDateFormat() {
            return this.dateFormat;
        }

        public FileImportPage getFileImportPage() {
            return this.fileImportPage;
        }

        public void setFileName(String fileName) {
            this.fileName = fileName;
        }

        public void setFileFormat(FileFormat fileFormat) {
            this.fileFormat = fileFormat;
        }

        public void setDateFormat(DateFormat dateFormat) {
            this.dateFormat = dateFormat;
        }

        public void setFileImportPage(FileImportPage fileImportPage) {
            this.fileImportPage = fileImportPage;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof File)) {
                return false;
            }
            File other = (File)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$fileName = this.getFileName();
            String other$fileName = other.getFileName();
            if (this$fileName == null ? other$fileName != null : !this$fileName.equals(other$fileName)) {
                return false;
            }
            FileFormat this$fileFormat = this.getFileFormat();
            FileFormat other$fileFormat = other.getFileFormat();
            if (this$fileFormat == null ? other$fileFormat != null : !((Object)((Object)this$fileFormat)).equals((Object)other$fileFormat)) {
                return false;
            }
            DateFormat this$dateFormat = this.getDateFormat();
            DateFormat other$dateFormat = other.getDateFormat();
            if (this$dateFormat == null ? other$dateFormat != null : !((Object)((Object)this$dateFormat)).equals((Object)other$dateFormat)) {
                return false;
            }
            FileImportPage this$fileImportPage = this.getFileImportPage();
            FileImportPage other$fileImportPage = other.getFileImportPage();
            return !(this$fileImportPage == null ? other$fileImportPage != null : !((Object)this$fileImportPage).equals(other$fileImportPage));
        }

        protected boolean canEqual(Object other) {
            return other instanceof File;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $fileName = this.getFileName();
            result = result * 59 + ($fileName == null ? 43 : $fileName.hashCode());
            FileFormat $fileFormat = this.getFileFormat();
            result = result * 59 + ($fileFormat == null ? 43 : ((Object)((Object)$fileFormat)).hashCode());
            DateFormat $dateFormat = this.getDateFormat();
            result = result * 59 + ($dateFormat == null ? 43 : ((Object)((Object)$dateFormat)).hashCode());
            FileImportPage $fileImportPage = this.getFileImportPage();
            result = result * 59 + ($fileImportPage == null ? 43 : ((Object)$fileImportPage).hashCode());
            return result;
        }

        public String toString() {
            return "FileImportRequest.File(fileName=" + this.getFileName() + ", fileFormat=" + (Object)((Object)this.getFileFormat()) + ", dateFormat=" + (Object)((Object)this.getDateFormat()) + ", fileImportPage=" + this.getFileImportPage() + ")";
        }
    }
}

