/*
 * Decompiled with CFR 0.152.
 */
package io.castled.apps.connectors.hubspot.client;

import com.google.common.collect.Lists;
import io.castled.ObjectRegistry;
import io.castled.apps.connectors.hubspot.HubspotAccessConfig;
import io.castled.apps.connectors.hubspot.client.HubspotErrorCategory;
import io.castled.apps.connectors.hubspot.client.dtos.BatchObjectError;
import io.castled.apps.connectors.hubspot.client.dtos.BatchUpdateRequest;
import io.castled.apps.connectors.hubspot.client.dtos.HubspotObject;
import io.castled.apps.connectors.hubspot.client.dtos.HubspotProperty;
import io.castled.apps.connectors.hubspot.client.dtos.PaginatedObjects;
import io.castled.apps.connectors.hubspot.client.exception.BatchObjectException;
import io.castled.apps.connectors.hubspot.oauth.HubspotAccessTokenRefresher;
import io.castled.core.WaitTimeAndRetry;
import io.castled.exceptions.CastledRuntimeException;
import io.castled.functionalinterfaces.ThrowingSupplier;
import io.castled.oauth.OAuthClientConfig;
import io.castled.oauth.OAuthDAO;
import io.castled.oauth.OAuthDetails;
import io.castled.utils.JsonUtils;
import io.castled.utils.ResponseUtils;
import io.castled.utils.RetryUtils;
import io.castled.utils.ThreadUtils;
import io.castled.utils.TimeUtils;
import java.net.SocketTimeoutException;
import java.util.List;
import java.util.function.Consumer;
import javax.ws.rs.NotAuthorizedException;
import javax.ws.rs.client.Client;
import javax.ws.rs.client.Entity;
import javax.ws.rs.client.WebTarget;
import javax.ws.rs.core.GenericType;
import javax.ws.rs.core.Response;
import org.apache.commons.lang3.mutable.MutableObject;
import org.jdbi.v3.core.Jdbi;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HubspotRestClient {
    private static final Logger log = LoggerFactory.getLogger(HubspotRestClient.class);
    private static final String HUBSPOT_BASE_URL = "https://api.hubapi.com";
    private final Client client;
    private final HubspotAccessTokenRefresher accessTokenRefresher;
    private final Long oauthToken;
    private HubspotAccessConfig hubspotAccessConfig;

    public HubspotRestClient(Long oauthToken, OAuthClientConfig oAuthClientConfig) {
        this.oauthToken = oauthToken;
        this.client = (Client)ObjectRegistry.getInstance(Client.class);
        OAuthDetails oAuthDetails = ((OAuthDAO)((Jdbi)ObjectRegistry.getInstance(Jdbi.class)).onDemand(OAuthDAO.class)).getOAuthDetails(oauthToken);
        this.hubspotAccessConfig = (HubspotAccessConfig)oAuthDetails.getAccessConfig();
        this.accessTokenRefresher = new HubspotAccessTokenRefresher(oAuthClientConfig);
    }

    public List<HubspotProperty> getObjectProperties(String objectType) {
        return (List)this.executeRequest(() -> (List)this.client.target(String.format("%s/properties/v2/%s/properties", HUBSPOT_BASE_URL, objectType)).request(new String[]{"application/json"}).header("Authorization", (Object)("Bearer " + this.hubspotAccessConfig.getAccessToken())).get((GenericType)new GenericType<List<HubspotProperty>>(){}));
    }

    private void doUpdateObjects(String batchUpdateUrl, BatchUpdateRequest batchUpdateRequest, boolean create, int retries) throws BatchObjectException {
        String batchUrl = String.format("%s/crm/v3/objects/%s/batch/%s", HUBSPOT_BASE_URL, batchUpdateUrl, create ? "create" : "update");
        try (Response response = (Response)this.executeRequest(() -> this.client.target(batchUrl).request(new String[]{"application/json"}).header("Authorization", (Object)("Bearer " + this.hubspotAccessConfig.getAccessToken())).post(Entity.json((Object)batchUpdateRequest)));){
            if (!ResponseUtils.is2xx((Response)response)) {
                if (response.getStatus() == 502) {
                    if (retries < 3) {
                        ThreadUtils.interruptIgnoredSleep((long)TimeUtils.secondsToMillis((long)10L));
                        this.doUpdateObjects(batchUpdateUrl, batchUpdateRequest, create, retries + 1);
                        return;
                    }
                    throw new BatchObjectException(new BatchObjectError(null, "Hubspot server unavailable", HubspotErrorCategory.SERVER_DOWN.name()));
                }
                String errorString = (String)response.readEntity(String.class);
                log.error("Hubspot error:" + errorString);
                log.error("Hubspot error code:" + response.getStatus());
                BatchObjectError batchObjectError = (BatchObjectError)JsonUtils.jsonStringToObject((String)errorString, BatchObjectError.class);
                if (batchObjectError.getMessage().contains("You have reached your ten_secondly_rolling limit")) {
                    ThreadUtils.interruptIgnoredSleep((long)TimeUtils.secondsToMillis((long)5L));
                    this.doUpdateObjects(batchUpdateUrl, batchUpdateRequest, create, retries + 1);
                    return;
                }
                throw new BatchObjectException(batchObjectError);
            }
        }
    }

    public void updateObjects(String batchUpdateUrl, BatchUpdateRequest batchUpdateRequest, boolean create) throws BatchObjectException {
        this.doUpdateObjects(batchUpdateUrl, batchUpdateRequest, create, 0);
    }

    public void consumeObjects(List<String> properties, String objectType, Consumer<HubspotObject> objectConsumer) {
        MutableObject paginatedObjects = new MutableObject();
        while (paginatedObjects.getValue() == null || ((PaginatedObjects)paginatedObjects.getValue()).hasMore()) {
            paginatedObjects.setValue((Object)((PaginatedObjects)this.executeRequest(() -> {
                WebTarget webTarget = this.client.target(String.format("%s/crm/v3/objects/%s", HUBSPOT_BASE_URL, objectType));
                for (String property : properties) {
                    webTarget = webTarget.queryParam("properties", new Object[]{property});
                }
                if (paginatedObjects.getValue() != null) {
                    webTarget = webTarget.queryParam("after", new Object[]{((PaginatedObjects)paginatedObjects.getValue()).getPaging().getNext().getAfter()});
                }
                webTarget = webTarget.queryParam("limit", new Object[]{100});
                return (PaginatedObjects)webTarget.request(new String[]{"application/json"}).header("Authorization", (Object)("Bearer " + this.hubspotAccessConfig.getAccessToken())).get(PaginatedObjects.class);
            })));
            ((PaginatedObjects)paginatedObjects.getValue()).getResults().forEach(objectConsumer);
        }
    }

    private <T> T executeRequest(ThrowingSupplier<T> supplier) {
        try {
            return (T)RetryUtils.retrySupplier(supplier, (int)3, (List)Lists.newArrayList((Object[])new Class[]{NotAuthorizedException.class, SocketTimeoutException.class}), (throwable, attempts) -> {
                if (throwable instanceof NotAuthorizedException && attempts <= 1) {
                    this.hubspotAccessConfig = this.accessTokenRefresher.refreshAccessConfig(this.oauthToken);
                    return new WaitTimeAndRetry(0L, true);
                }
                if (throwable instanceof SocketTimeoutException && attempts <= 3) {
                    return new WaitTimeAndRetry(TimeUtils.secondsToMillis((long)10L), true);
                }
                return new WaitTimeAndRetry(0L, false);
            });
        }
        catch (Exception e) {
            throw new CastledRuntimeException((Throwable)e);
        }
    }
}

