/*
 * Decompiled with CFR 0.152.
 */
package io.castled.apps.connectors.hubspot;

import com.fasterxml.jackson.core.type.TypeReference;
import com.google.inject.Singleton;
import io.castled.apps.connectors.hubspot.client.HubspotErrorCategory;
import io.castled.apps.connectors.hubspot.client.dtos.BatchObjectError;
import io.castled.apps.connectors.hubspot.client.dtos.RecordError;
import io.castled.commons.errors.CastledError;
import io.castled.commons.errors.errorclassifications.ExternallyCategorizedError;
import io.castled.commons.errors.errorclassifications.InvalidFieldValueError;
import io.castled.commons.errors.errorclassifications.UnclassifiedError;
import io.castled.utils.JsonUtils;
import java.util.List;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

@Singleton
public class HubspotErrorParser {
    private static final Pattern INVALID_FIELD_VALUE_PATTERN = Pattern.compile("Property values were not valid: (.*)");

    public CastledError parseError(RecordError recordError) {
        return new UnclassifiedError(recordError.getExtraContext());
    }

    public CastledError parseError(BatchObjectError batchObjectError) {
        if (batchObjectError == null) {
            return new UnclassifiedError("Unknown error");
        }
        if (batchObjectError.getCategory() == null) {
            return new UnclassifiedError(Optional.ofNullable(batchObjectError.getMessage()).orElse("unknown error"));
        }
        if (batchObjectError.getCategory().equals(HubspotErrorCategory.VALIDATION_ERROR.name())) {
            return this.parseInvalidFieldValueError(batchObjectError);
        }
        return new ExternallyCategorizedError(batchObjectError.getCategory(), batchObjectError.getMessage());
    }

    private CastledError parseInvalidFieldValueError(BatchObjectError batchObjectError) {
        List invalidValueErrors;
        Matcher matcher = INVALID_FIELD_VALUE_PATTERN.matcher(batchObjectError.getMessage());
        if (matcher.find() && (invalidValueErrors = (List)JsonUtils.jsonStringToTypeReference((String)matcher.group(1), (TypeReference)new TypeReference<List<InvalidValueError>>(){})).size() == 1) {
            InvalidValueError invalidValueError = (InvalidValueError)invalidValueErrors.get(0);
            return new InvalidFieldValueError(invalidValueError.getName(), invalidValueError.getError(), invalidValueError.getMessage());
        }
        return new ExternallyCategorizedError(batchObjectError.getCategory(), batchObjectError.getMessage());
    }

    private static class InvalidValueError {
        private String message;
        private String error;
        private String name;

        public String getMessage() {
            return this.message;
        }

        public String getError() {
            return this.error;
        }

        public String getName() {
            return this.name;
        }

        public void setMessage(String message) {
            this.message = message;
        }

        public void setError(String error) {
            this.error = error;
        }

        public void setName(String name) {
            this.name = name;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof InvalidValueError)) {
                return false;
            }
            InvalidValueError other = (InvalidValueError)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$message = this.getMessage();
            String other$message = other.getMessage();
            if (this$message == null ? other$message != null : !this$message.equals(other$message)) {
                return false;
            }
            String this$error = this.getError();
            String other$error = other.getError();
            if (this$error == null ? other$error != null : !this$error.equals(other$error)) {
                return false;
            }
            String this$name = this.getName();
            String other$name = other.getName();
            return !(this$name == null ? other$name != null : !this$name.equals(other$name));
        }

        protected boolean canEqual(Object other) {
            return other instanceof InvalidValueError;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $message = this.getMessage();
            result = result * 59 + ($message == null ? 43 : $message.hashCode());
            String $error = this.getError();
            result = result * 59 + ($error == null ? 43 : $error.hashCode());
            String $name = this.getName();
            result = result * 59 + ($name == null ? 43 : $name.hashCode());
            return result;
        }

        public String toString() {
            return "HubspotErrorParser.InvalidValueError(message=" + this.getMessage() + ", error=" + this.getError() + ", name=" + this.getName() + ")";
        }

        public InvalidValueError(String message, String error, String name) {
            this.message = message;
            this.error = error;
            this.name = name;
        }

        public InvalidValueError() {
        }
    }
}

