/*
 * Decompiled with CFR 0.152.
 */
package io.castled.apps.connectors.googlesheets;

import com.google.api.client.googleapis.javanet.GoogleNetHttpTransport;
import com.google.api.client.http.HttpRequestInitializer;
import com.google.api.client.http.HttpTransport;
import com.google.api.client.http.javanet.NetHttpTransport;
import com.google.api.client.json.JsonFactory;
import com.google.api.client.json.jackson2.JacksonFactory;
import com.google.api.services.sheets.v4.Sheets;
import com.google.api.services.sheets.v4.model.ValueRange;
import com.google.auth.Credentials;
import com.google.auth.http.HttpCredentialsAdapter;
import com.google.auth.oauth2.GoogleCredentials;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import io.castled.apps.connectors.googlesheets.SheetRow;
import io.castled.commons.models.ServiceAccountDetails;
import io.castled.schema.models.Field;
import io.castled.utils.JsonUtils;
import io.castled.utils.ListUtils;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;

public class GoogleSheetUtils {
    private static final Pattern SPREADSHEET_PATTERN = Pattern.compile("https://docs.google.com/spreadsheets/d/(.*)/edit#gid=0");

    public static Sheets getSheets(ServiceAccountDetails serviceAccountDetails) throws Exception {
        GoogleCredentials googleCredentials;
        NetHttpTransport HTTP_TRANSPORT = GoogleNetHttpTransport.newTrustedTransport();
        List<String> SCOPES = Collections.singletonList("https://www.googleapis.com/auth/spreadsheets");
        try (ByteArrayInputStream serviceAccountStream = new ByteArrayInputStream(JsonUtils.objectToByteArray((Object)serviceAccountDetails));){
            googleCredentials = GoogleCredentials.fromStream((InputStream)serviceAccountStream).createScoped(SCOPES);
        }
        return new Sheets.Builder((HttpTransport)HTTP_TRANSPORT, (JsonFactory)JacksonFactory.getDefaultInstance(), (HttpRequestInitializer)new HttpCredentialsAdapter((Credentials)googleCredentials)).setApplicationName("Castled").build();
    }

    public static String getSpreadSheetId(String spreadsheetUrl) {
        Matcher matcher = SPREADSHEET_PATTERN.matcher(spreadsheetUrl);
        if (matcher.find()) {
            return matcher.group(1);
        }
        return spreadsheetUrl;
    }

    public static boolean validSpreadSheetUrl(String spreadsheetUrl) {
        return SPREADSHEET_PATTERN.matcher(spreadsheetUrl).find();
    }

    public static List<SheetRow> getRows(Sheets sheetsService, String spreadSheetId, String sheetName) throws IOException {
        List sheetEntries = ((ValueRange)sheetsService.spreadsheets().values().get(spreadSheetId, sheetName).execute()).getValues();
        if (CollectionUtils.isEmpty((Collection)sheetEntries) || sheetEntries.size() == 1) {
            return null;
        }
        List<String> headers = ((List)sheetEntries.get(0)).stream().map(String::valueOf).collect(Collectors.toList());
        List rowValues = sheetEntries.subList(1, sheetEntries.size());
        ArrayList sheetRows = Lists.newArrayList();
        for (int i = 0; i < rowValues.size(); ++i) {
            sheetRows.add(new SheetRow(i + 2, GoogleSheetUtils.getSheetValues(headers, (List)rowValues.get(i))));
        }
        return sheetRows;
    }

    private static LinkedHashMap<String, Object> getSheetValues(List<String> headers, List<Object> rowValue) {
        LinkedHashMap sheetValues = Maps.newLinkedHashMap();
        for (int index = 0; index < headers.size(); ++index) {
            sheetValues.put(headers.get(index), ListUtils.nullOnIndexOutOfBounds(rowValue, index));
        }
        return sheetValues;
    }

    public static Integer getPrimaryKeysHash(Map<String, Object> row, List<String> primaryKeys) {
        return primaryKeys.stream().map(row::get).collect(Collectors.toList()).hashCode();
    }

    public static Object getSheetsValue(Field field) {
        if (field == null) {
            return "";
        }
        switch (field.getSchema().getType()) {
            case DATE: {
                LocalDate localDate = (LocalDate)field.getValue();
                return localDate.format(DateTimeFormatter.ISO_LOCAL_DATE);
            }
            case TIMESTAMP: {
                LocalDateTime localDateTime = (LocalDateTime)field.getValue();
                return localDateTime.format(DateTimeFormatter.ISO_LOCAL_DATE_TIME);
            }
            case ZONED_TIMESTAMP: {
                ZonedDateTime zonedDateTime = (ZonedDateTime)field.getValue();
                return zonedDateTime.format(DateTimeFormatter.ISO_ZONED_DATE_TIME);
            }
            case TIME: {
                LocalTime localTime = (LocalTime)field.getValue();
                return localTime.format(DateTimeFormatter.ISO_TIME);
            }
            case INT: 
            case LONG: {
                return String.valueOf(field.getValue());
            }
        }
        return field.getValue();
    }

    public static String getRange(String sheetName, long rowNo) {
        return String.format("%s!%d:%d", sheetName, rowNo, rowNo);
    }
}

