/*
 * Decompiled with CFR 0.152.
 */
package io.castled.apps.connectors.googlepubsub;

import com.google.api.gax.core.CredentialsProvider;
import com.google.cloud.pubsub.v1.TopicAdminClient;
import com.google.cloud.pubsub.v1.TopicAdminSettings;
import com.google.common.collect.Lists;
import com.google.pubsub.v1.ProjectName;
import io.castled.ObjectRegistry;
import io.castled.apps.ExternalAppConnector;
import io.castled.apps.connectors.googlepubsub.GooglePubSubAppConfig;
import io.castled.apps.connectors.googlepubsub.GooglePubSubAppSyncConfig;
import io.castled.apps.connectors.googlepubsub.GooglePubSubCredentialsProvider;
import io.castled.apps.connectors.googlepubsub.GooglePubSubDataSink;
import io.castled.apps.connectors.googlepubsub.GooglePubSubTopicSyncObject;
import io.castled.apps.models.ExternalAppSchema;
import io.castled.commons.models.AppSyncMode;
import io.castled.commons.models.ServiceAccountDetails;
import io.castled.exceptions.connect.InvalidConfigException;
import io.castled.forms.dtos.FormFieldOption;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import javax.inject.Singleton;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class GooglePubSubAppConnector
implements ExternalAppConnector<GooglePubSubAppConfig, GooglePubSubDataSink, GooglePubSubAppSyncConfig> {
    private static final Logger log = LoggerFactory.getLogger(GooglePubSubAppConnector.class);

    @Override
    public List<FormFieldOption> getAllObjects(GooglePubSubAppConfig config, GooglePubSubAppSyncConfig mappingConfig) {
        ArrayList formFieldOptions = Lists.newArrayList();
        try (TopicAdminClient topicAdminClient = TopicAdminClient.create((TopicAdminSettings)((TopicAdminSettings.Builder)TopicAdminSettings.newBuilder().setCredentialsProvider((CredentialsProvider)new GooglePubSubCredentialsProvider(config.getServiceAccountDetails()))).build());){
            topicAdminClient.listTopics(ProjectName.of((String)config.getProjectID())).iterateAll().forEach(topic -> formFieldOptions.add(new FormFieldOption((Object)new GooglePubSubTopicSyncObject(topic.getName().split("/")[3], topic.getName()), topic.getName())));
        }
        catch (IOException ioException) {
            log.error("Exception while fetching topics", (Throwable)ioException);
        }
        return formFieldOptions;
    }

    @Override
    public GooglePubSubDataSink getDataSink() {
        return (GooglePubSubDataSink)ObjectRegistry.getInstance(GooglePubSubDataSink.class);
    }

    @Override
    public ExternalAppSchema getSchema(GooglePubSubAppConfig config, GooglePubSubAppSyncConfig kafkaAppSyncConfig) {
        return new ExternalAppSchema(null, Lists.newArrayList());
    }

    @Override
    public Class<GooglePubSubAppSyncConfig> getMappingConfigType() {
        return GooglePubSubAppSyncConfig.class;
    }

    @Override
    public Class<GooglePubSubAppConfig> getAppConfigType() {
        return GooglePubSubAppConfig.class;
    }

    @Override
    public List<AppSyncMode> getSyncModes(GooglePubSubAppConfig kafkaAppConfig, GooglePubSubAppSyncConfig kafkaAppSyncConfig) {
        return Lists.newArrayList((Object[])new AppSyncMode[]{AppSyncMode.INSERT});
    }

    @Override
    public void validateAppConfig(GooglePubSubAppConfig appConfig) throws InvalidConfigException {
        String projectID = Optional.ofNullable(appConfig.getProjectID()).orElseThrow(() -> new InvalidConfigException("Project ID is mandatory"));
        ServiceAccountDetails serviceAccountDetails = Optional.ofNullable(appConfig.getServiceAccountDetails()).orElseThrow(() -> new InvalidConfigException("Service Account JSON is not uploaded"));
        ArrayList topics = Lists.newArrayList();
        try (TopicAdminClient topicAdminClient = TopicAdminClient.create((TopicAdminSettings)((TopicAdminSettings.Builder)TopicAdminSettings.newBuilder().setCredentialsProvider((CredentialsProvider)new GooglePubSubCredentialsProvider(serviceAccountDetails))).build());){
            topicAdminClient.listTopics(ProjectName.of((String)projectID)).iterateAll().forEach(topic -> topics.add(topic.getName()));
            if (CollectionUtils.isEmpty((Collection)topics)) {
                new InvalidConfigException("Project don't have topics");
            }
        }
        catch (IOException ioException) {
            log.error("Exception while fetching topics", (Throwable)ioException);
            new InvalidConfigException("Config Incorrect");
        }
        catch (Exception exception) {
            new InvalidConfigException("Project ID/JSON entered is incorrect");
        }
    }
}

