/*
 * Decompiled with CFR 0.152.
 */
package io.castled.apps.connectors.googleads;

import com.google.ads.googleads.v7.errors.GoogleAdsError;
import com.google.rpc.Status;
import io.castled.ObjectRegistry;
import io.castled.apps.BufferedObjectSink;
import io.castled.apps.connectors.googleads.GadsErrorParser;
import io.castled.apps.connectors.googleads.GadsErrorUtils;
import io.castled.commons.errors.CastledError;
import io.castled.commons.models.MessageSyncStats;
import io.castled.commons.streams.ErrorOutputStream;
import io.castled.exceptions.CastledRuntimeException;
import io.castled.schema.models.Message;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.atomic.AtomicLong;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class GadsObjectSink
extends BufferedObjectSink<Message> {
    private static final Logger log = LoggerFactory.getLogger(GadsObjectSink.class);
    private final ErrorOutputStream errorOutputStream;
    protected final AtomicLong processedRecords = new AtomicLong(0L);
    protected long lastProcessedMessageId = 0L;

    public GadsObjectSink(ErrorOutputStream errorOutputStream) {
        this.errorOutputStream = errorOutputStream;
    }

    protected void handlePartialFailures(List<Message> messages, Status partialFailureError) {
        for (int operationIndex = 0; operationIndex < messages.size(); ++operationIndex) {
            GoogleAdsError googleAdsError = this.getGoogleAdsError(operationIndex, partialFailureError);
            if (googleAdsError == null) continue;
            CastledError pipelineError = ((GadsErrorParser)ObjectRegistry.getInstance(GadsErrorParser.class)).parseGadsError(googleAdsError);
            this.errorOutputStream.writeFailedRecord(messages.get(operationIndex), pipelineError);
        }
    }

    private GoogleAdsError getGoogleAdsError(long operationIndex, Status partialFailureError) {
        try {
            Iterator<GoogleAdsError> iterator = ((GadsErrorUtils)((Object)ObjectRegistry.getInstance(GadsErrorUtils.class))).getErrors(operationIndex, partialFailureError).iterator();
            if (iterator.hasNext()) {
                GoogleAdsError error = iterator.next();
                return error;
            }
            return null;
        }
        catch (Throwable e) {
            log.error("Protocol1 buffer exception while getting partial failure errors", e);
            throw new CastledRuntimeException(e);
        }
    }

    public MessageSyncStats getSyncStats() {
        return new MessageSyncStats(this.processedRecords.get(), this.lastProcessedMessageId);
    }

    @Override
    public long getMaxBufferedObjects() {
        return 10000L;
    }
}

