/*
 * Decompiled with CFR 0.152.
 */
package io.castled.apps.connectors.googleads;

import com.google.ads.googleads.lib.utils.AbstractErrorUtils;
import com.google.ads.googleads.v7.errors.GoogleAdsError;
import com.google.ads.googleads.v7.errors.GoogleAdsFailure;
import com.google.ads.googleads.v7.utils.ErrorUtils;
import com.google.common.collect.Lists;
import com.google.inject.Singleton;
import com.google.protobuf.Any;
import com.google.protobuf.InvalidProtocolBufferException;
import com.google.protobuf.Message;
import com.google.rpc.Status;
import java.util.ArrayList;
import java.util.List;

@Singleton
public class GadsErrorUtils
extends ErrorUtils {
    public List<GoogleAdsError> getErrors(long operationIndex, Status partialFailure) throws InvalidProtocolBufferException {
        ArrayList result = Lists.newArrayList();
        for (Any detail : partialFailure.getDetailsList()) {
            GoogleAdsFailure failure = (GoogleAdsFailure)this.getGoogleAdsFailure(detail);
            result.addAll(this.getAdsErrors(operationIndex, failure));
        }
        return result;
    }

    public List<GoogleAdsError> getAdsErrors(long operationIndex, GoogleAdsFailure googleAdsFailure) {
        ArrayList result = Lists.newArrayList();
        for (AbstractErrorUtils.ErrorPath path : this.getErrorPaths((Message)googleAdsFailure)) {
            GoogleAdsError error;
            if (!path.getIndex().isPresent() || (Long)path.getIndex().get() != operationIndex || result.contains(error = (GoogleAdsError)path.getError())) continue;
            result.add((GoogleAdsError)path.getError());
        }
        return result;
    }
}

