/*
 * Decompiled with CFR 0.152.
 */
package io.castled.apps.connectors.googleads;

import com.google.ads.googleads.lib.GoogleAdsClient;
import com.google.ads.googleads.v7.common.CustomerMatchUserListMetadata;
import com.google.ads.googleads.v7.common.OfflineUserAddressInfo;
import com.google.ads.googleads.v7.common.UserData;
import com.google.ads.googleads.v7.common.UserIdentifier;
import com.google.ads.googleads.v7.enums.OfflineUserDataJobTypeEnum;
import com.google.ads.googleads.v7.resources.OfflineUserDataJob;
import com.google.ads.googleads.v7.services.AddOfflineUserDataJobOperationsRequest;
import com.google.ads.googleads.v7.services.AddOfflineUserDataJobOperationsResponse;
import com.google.ads.googleads.v7.services.CreateOfflineUserDataJobResponse;
import com.google.ads.googleads.v7.services.OfflineUserDataJobOperation;
import com.google.ads.googleads.v7.services.OfflineUserDataJobServiceClient;
import io.castled.ObjectRegistry;
import io.castled.apps.connectors.googleads.GadsObjectFields;
import io.castled.apps.connectors.googleads.GadsObjectSink;
import io.castled.apps.connectors.googleads.GoogleAdUtils;
import io.castled.apps.connectors.googleads.GoogleAdsAppConfig;
import io.castled.apps.connectors.googleads.GoogleAdsAppSyncConfig;
import io.castled.commons.streams.ErrorOutputStream;
import io.castled.exceptions.CastledRuntimeException;
import io.castled.oauth.OAuthDAO;
import io.castled.oauth.OAuthDetails;
import io.castled.schema.models.Message;
import io.castled.schema.models.Tuple;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import org.jdbi.v3.core.Jdbi;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CustomerMatchObjectSink
extends GadsObjectSink {
    private static final Logger log = LoggerFactory.getLogger(CustomerMatchObjectSink.class);
    private final GoogleAdsAppSyncConfig mappingConfig;
    private final String offlineUserDataJobResource;
    private final OfflineUserDataJobServiceClient offlineUserDataJobServiceClient;

    public CustomerMatchObjectSink(GoogleAdsAppSyncConfig mappingConfig, GoogleAdsAppConfig googleAdsAppConfig, ErrorOutputStream errorOutputStream) {
        super(errorOutputStream);
        this.mappingConfig = mappingConfig;
        OAuthDetails oAuthDetails = ((OAuthDAO)((Jdbi)ObjectRegistry.getInstance(Jdbi.class)).onDemand(OAuthDAO.class)).getOAuthDetails(googleAdsAppConfig.getOAuthToken());
        GoogleAdsClient googleAdsClient = GoogleAdsClient.newBuilder().fromProperties(GoogleAdUtils.getClientProperties(googleAdsAppConfig, oAuthDetails.getAccessConfig().getRefreshToken(), mappingConfig.getLoginCustomerId())).build();
        this.offlineUserDataJobServiceClient = googleAdsClient.getLatestVersion().createOfflineUserDataJobServiceClient();
        this.offlineUserDataJobResource = this.createOfflineUserDataJob();
    }

    private static String toSHA256String(String str) {
        MessageDigest digest = CustomerMatchObjectSink.getSHA256MessageDigest();
        byte[] hash = digest.digest(CustomerMatchObjectSink.toNormalizedString(str).getBytes(StandardCharsets.UTF_8));
        StringBuilder result = new StringBuilder();
        for (byte b : hash) {
            result.append(String.format("%02x", b));
        }
        return result.toString();
    }

    private static MessageDigest getSHA256MessageDigest() {
        try {
            return MessageDigest.getInstance("SHA-256");
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException("Missing SHA-256 algorithm implementation.", e);
        }
    }

    private static String toNormalizedString(String value) {
        return value.trim().toLowerCase();
    }

    private String createOfflineUserDataJob() {
        OfflineUserDataJob offlineUserDataJob = OfflineUserDataJob.newBuilder().setType(OfflineUserDataJobTypeEnum.OfflineUserDataJobType.CUSTOMER_MATCH_USER_LIST).setCustomerMatchUserListMetadata(CustomerMatchUserListMetadata.newBuilder().setUserList(this.mappingConfig.getSubResource().getResourceName())).build();
        CreateOfflineUserDataJobResponse createOfflineUserDataJobResponse = this.offlineUserDataJobServiceClient.createOfflineUserDataJob(String.valueOf(this.mappingConfig.getAccountId()), offlineUserDataJob);
        return createOfflineUserDataJobResponse.getResourceName();
    }

    @Override
    protected void writeRecords(List<Message> messages) {
        List userDataJobOperations = messages.stream().map(this::getUserDataOperation).filter(Objects::nonNull).collect(Collectors.toList());
        AddOfflineUserDataJobOperationsResponse response = this.offlineUserDataJobServiceClient.addOfflineUserDataJobOperations(AddOfflineUserDataJobOperationsRequest.newBuilder().setResourceName(this.offlineUserDataJobResource).setEnablePartialFailure(true).addAllOperations(userDataJobOperations).build());
        if (response.hasPartialFailureError()) {
            this.handlePartialFailures(messages, response.getPartialFailureError());
        }
        this.processedRecords.addAndGet(messages.size());
        this.lastProcessedMessageId = Math.min(this.lastProcessedMessageId, messages.get(messages.size() - 1).getOffset());
    }

    private OfflineUserDataJobOperation getUserDataOperation(Message message) {
        UserIdentifier userIdentifier = this.getUserIdentifier(message.getRecord());
        if (userIdentifier == null) {
            return null;
        }
        return OfflineUserDataJobOperation.newBuilder().setCreate(UserData.newBuilder().addUserIdentifiers(this.getUserIdentifier(message.getRecord()))).build();
    }

    private UserIdentifier getUserIdentifier(Tuple record) {
        switch (this.mappingConfig.getSubResource().getCustomerMatchType()) {
            case CONTACT_INFO: {
                return this.getContactInfoIdentifer(record);
            }
            case MOBILE_ADVERTISING_ID: {
                return this.getMobileDeviceIdentifier(record);
            }
            case CRM_ID: {
                return this.getThirdPartyUserIdentifier(record);
            }
        }
        throw new CastledRuntimeException(String.format("Unhandled customer match type %s", new Object[]{this.mappingConfig.getSubResource().getCustomerMatchType()}));
    }

    private UserIdentifier getContactInfoIdentifer(Tuple record) {
        String firstName = (String)record.getValue(GadsObjectFields.CUSTOMER_MATCH_CONTACT_INFO_FIELDS.FIRST_NAME.getFieldName());
        String lastName = (String)record.getValue(GadsObjectFields.CUSTOMER_MATCH_CONTACT_INFO_FIELDS.LAST_NAME.getFieldName());
        String countryCode = (String)record.getValue(GadsObjectFields.CUSTOMER_MATCH_CONTACT_INFO_FIELDS.COUNTRY_CODE.getFieldName());
        String email = (String)record.getValue(GadsObjectFields.CUSTOMER_MATCH_CONTACT_INFO_FIELDS.EMAIL.getFieldName());
        String postalCode = (String)record.getValue(GadsObjectFields.CUSTOMER_MATCH_CONTACT_INFO_FIELDS.POSTAL_CODE.getFieldName());
        String phoneNumber = (String)record.getValue(GadsObjectFields.CUSTOMER_MATCH_CONTACT_INFO_FIELDS.PHONE_NUMBER.getFieldName());
        OfflineUserAddressInfo.Builder userAddressBuilder = OfflineUserAddressInfo.newBuilder();
        Optional.ofNullable(firstName).ifPresent(fnRef -> userAddressBuilder.setHashedFirstName(CustomerMatchObjectSink.toSHA256String(fnRef)));
        Optional.ofNullable(lastName).ifPresent(lnRef -> userAddressBuilder.setHashedLastName(CustomerMatchObjectSink.toSHA256String(lnRef)));
        Optional.ofNullable(countryCode).ifPresent(arg_0 -> ((OfflineUserAddressInfo.Builder)userAddressBuilder).setCountryCode(arg_0));
        Optional.ofNullable(postalCode).ifPresent(arg_0 -> ((OfflineUserAddressInfo.Builder)userAddressBuilder).setPostalCode(arg_0));
        UserIdentifier.Builder userIdBuilder = UserIdentifier.newBuilder();
        userIdBuilder.setAddressInfo(userAddressBuilder.build());
        Optional.ofNullable(email).ifPresent(emailRef -> userIdBuilder.setHashedEmail(CustomerMatchObjectSink.toSHA256String(emailRef)));
        Optional.ofNullable(phoneNumber).ifPresent(phoneRef -> userIdBuilder.setHashedPhoneNumber(CustomerMatchObjectSink.toSHA256String(phoneRef)));
        return userIdBuilder.build();
    }

    private UserIdentifier getMobileDeviceIdentifier(Tuple record) {
        UserIdentifier.Builder userIdBuilder = UserIdentifier.newBuilder();
        String mobileDeviceId = (String)record.getValue("Mobile Device Id");
        if (mobileDeviceId == null) {
            return null;
        }
        return userIdBuilder.setMobileId(mobileDeviceId).build();
    }

    private UserIdentifier getThirdPartyUserIdentifier(Tuple record) {
        UserIdentifier.Builder userIdBuilder = UserIdentifier.newBuilder();
        String thirdPartyUserId = (String)record.getValue("User Id");
        if (thirdPartyUserId == null) {
            return null;
        }
        return userIdBuilder.setThirdPartyUserId(thirdPartyUserId).build();
    }

    @Override
    public void afterRecordsFlush() {
        this.offlineUserDataJobServiceClient.runOfflineUserDataJobAsync(this.offlineUserDataJobResource);
        this.offlineUserDataJobServiceClient.close();
    }
}

