/*
 * Decompiled with CFR 0.152.
 */
package io.castled.apps.connectors.customerio;

import com.google.common.collect.Maps;
import io.castled.ObjectRegistry;
import io.castled.apps.connectors.customerio.CustomerIOAppConfig;
import io.castled.apps.connectors.customerio.CustomerIOAppSyncConfig;
import io.castled.apps.connectors.customerio.CustomerIOErrorParser;
import io.castled.apps.connectors.customerio.CustomerIOObjectFields;
import io.castled.apps.connectors.customerio.CustomerIOObjectSink;
import io.castled.apps.connectors.customerio.client.CustomerIORestClient;
import io.castled.apps.models.DataSinkRequest;
import io.castled.apps.models.GenericSyncObject;
import io.castled.commons.errors.CastledError;
import io.castled.commons.errors.errorclassifications.UnclassifiedError;
import io.castled.commons.models.AppSyncStats;
import io.castled.commons.models.MessageSyncStats;
import io.castled.commons.streams.ErrorOutputStream;
import io.castled.core.CastledOffsetQueue;
import io.castled.schema.SchemaUtils;
import io.castled.schema.models.Field;
import io.castled.schema.models.Message;
import io.castled.schema.models.MessageOffsetSupplier;
import io.castled.schema.models.Schema;
import io.castled.schema.models.Tuple;
import io.castled.utils.TimeUtils;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Consumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CustomerIOPersonSink
implements CustomerIOObjectSink<String> {
    private static final Logger log = LoggerFactory.getLogger(CustomerIOPersonSink.class);
    private final ErrorOutputStream errorOutputStream;
    private final CustomerIOAppSyncConfig syncConfig;
    private final AppSyncStats syncStats;
    private final List<String> primaryKeys;
    private final List<String> mappedFields;
    private final CustomerIORestClient customerIORestClient;
    private final CustomerIOErrorParser customerIOErrorParser;
    private final GenericSyncObject audienceSyncObject;
    private final AtomicLong failedRecords = new AtomicLong(0L);
    private final AtomicLong processedRecords = new AtomicLong(0L);
    private long lastProcessedOffset = 0L;
    private final CastledOffsetQueue<Message> companyRecordsBuffer = new CastledOffsetQueue((Consumer)new PersonConsumer(), 10, 10, true);

    public CustomerIOPersonSink(DataSinkRequest dataSinkRequest) {
        this.customerIORestClient = new CustomerIORestClient(((CustomerIOAppConfig)dataSinkRequest.getExternalApp().getConfig()).getSiteId(), ((CustomerIOAppConfig)dataSinkRequest.getExternalApp().getConfig()).getApiKey());
        this.errorOutputStream = dataSinkRequest.getErrorOutputStream();
        this.customerIOErrorParser = (CustomerIOErrorParser)ObjectRegistry.getInstance(CustomerIOErrorParser.class);
        this.audienceSyncObject = ((CustomerIOAppSyncConfig)dataSinkRequest.getAppSyncConfig()).getObject();
        this.syncConfig = (CustomerIOAppSyncConfig)dataSinkRequest.getAppSyncConfig();
        this.primaryKeys = dataSinkRequest.getPrimaryKeys();
        this.syncStats = new AppSyncStats(0L, 0L, 0L);
        this.mappedFields = dataSinkRequest.getMappedFields();
    }

    private String getEmail(Tuple record) {
        return (String)record.getValue(CustomerIOObjectFields.CONTACTS_FIELDS.EMAIL.getFieldName());
    }

    private String getId(Tuple record) {
        return (String)record.getValue(CustomerIOObjectFields.CONTACTS_FIELDS.ID.getFieldName());
    }

    @Override
    public void createOrUpdateObject(Message message) {
        try {
            this.companyRecordsBuffer.writePayload((MessageOffsetSupplier)message, 5, TimeUnit.MINUTES);
        }
        catch (TimeoutException e) {
            this.errorOutputStream.writeFailedRecord(message, new UnclassifiedError("Internal error! Unable to publish records to records queue. Please contact support"));
        }
    }

    @Override
    public void flushRecords() throws TimeoutException {
        this.companyRecordsBuffer.flush(TimeUtils.minutesToMillis((long)10L));
    }

    @Override
    public MessageSyncStats getSyncStats() {
        return new MessageSyncStats(this.processedRecords.get(), this.companyRecordsBuffer.getProcessedOffset());
    }

    private Map<String, Object> constructProperties(Tuple record) {
        HashMap recordProperties = Maps.newHashMap();
        for (Field field : record.getFields()) {
            Object value = record.getValue(field.getName());
            if (value == null) continue;
            if (SchemaUtils.isZonedTimestamp((Schema)field.getSchema())) {
                recordProperties.put(field.getName(), ((ZonedDateTime)value).toEpochSecond());
            }
            if (value instanceof LocalDate) {
                recordProperties.put(field.getName(), ((LocalDate)value).format(DateTimeFormatter.ofPattern("yyyy-MM-dd")));
                continue;
            }
            if (value instanceof LocalDateTime) {
                recordProperties.put(field.getName(), ((LocalDateTime)value).format(DateTimeFormatter.ofPattern("yyyy-MM-dd'T'HH:mm:ss")));
                continue;
            }
            recordProperties.put(field.getName(), value);
        }
        return recordProperties;
    }

    private class PersonConsumer
    implements Consumer<Message> {
        private PersonConsumer() {
        }

        @Override
        public void accept(Message message) {
            Map companyProperties = CustomerIOPersonSink.this.constructProperties(message.getRecord());
            try {
                CustomerIOPersonSink.this.customerIORestClient.upsertPersonDetails(companyProperties, CustomerIOPersonSink.this.primaryKeys);
            }
            catch (Exception e) {
                CustomerIOPersonSink.this.failedRecords.incrementAndGet();
                CastledError pipelineError = CustomerIOPersonSink.this.customerIOErrorParser.getPipelineError(e.getLocalizedMessage());
                CustomerIOPersonSink.this.errorOutputStream.writeFailedRecord(message, pipelineError);
            }
            CustomerIOPersonSink.this.processedRecords.incrementAndGet();
        }
    }
}

