/*
 * Decompiled with CFR 0.152.
 */
package io.castled.apps;

import com.google.common.collect.ImmutableMap;
import io.castled.commons.models.AccessType;
import io.castled.constants.ConnectorConstants;
import io.castled.oauth.OAuthServiceType;
import java.util.Map;
import java.util.Optional;

public enum ExternalAppType {
    GOOGLE_SHEETS((Map<String, Object>)ImmutableMap.builder().put((Object)ConnectorConstants.ACCESS_TYPE, (Object)((Object)AccessType.GOOGLE_SERVICE_ACCOUNT)).put((Object)ConnectorConstants.TITLE, (Object)"Google Sheets").put((Object)ConnectorConstants.LOGO_URL, (Object)"https://cdn.castled.io/apps/gsheets.png").build()),
    SALESFORCE((Map<String, Object>)ImmutableMap.builder().put((Object)ConnectorConstants.ACCESS_TYPE, (Object)((Object)AccessType.OAUTH)).put((Object)ConnectorConstants.TITLE, (Object)"Salesforce").put((Object)ConnectorConstants.LOGO_URL, (Object)"https://cdn.castled.io/apps/salesforce.png").put((Object)ConnectorConstants.OAUTH_SERVICE, (Object)((Object)OAuthServiceType.SALESFORCE)).build()),
    HUBSPOT((Map<String, Object>)ImmutableMap.builder().put((Object)ConnectorConstants.ACCESS_TYPE, (Object)((Object)AccessType.OAUTH)).put((Object)ConnectorConstants.TITLE, (Object)"Hubspot").put((Object)ConnectorConstants.LOGO_URL, (Object)"https://cdn.castled.io/apps/hubspot.svg").put((Object)ConnectorConstants.OAUTH_SERVICE, (Object)((Object)OAuthServiceType.HUBSPOT)).build()),
    INTERCOM((Map<String, Object>)ImmutableMap.builder().put((Object)ConnectorConstants.ACCESS_TYPE, (Object)((Object)AccessType.API_KEY)).put((Object)ConnectorConstants.TITLE, (Object)"Intercom").put((Object)ConnectorConstants.LOGO_URL, (Object)"https://cdn.castled.io/apps/intercom.png").build()),
    GOOGLEADS((Map<String, Object>)ImmutableMap.builder().put((Object)ConnectorConstants.ACCESS_TYPE, (Object)((Object)AccessType.OAUTH)).put((Object)ConnectorConstants.TITLE, (Object)"Google Ads").put((Object)ConnectorConstants.LOGO_URL, (Object)"https://cdn.castled.io/apps/gads.png").put((Object)ConnectorConstants.OAUTH_SERVICE, (Object)((Object)OAuthServiceType.GADS)).build()),
    MAILCHIMP((Map<String, Object>)ImmutableMap.builder().put((Object)ConnectorConstants.ACCESS_TYPE, (Object)((Object)AccessType.OAUTH)).put((Object)ConnectorConstants.TITLE, (Object)"Mailchimp").put((Object)ConnectorConstants.LOGO_URL, (Object)"https://cdn.castled.io/apps/mailchimp.png").put((Object)ConnectorConstants.OAUTH_SERVICE, (Object)((Object)OAuthServiceType.MAILCHIMP)).build()),
    SENDGRID((Map<String, Object>)ImmutableMap.builder().put((Object)ConnectorConstants.ACCESS_TYPE, (Object)((Object)AccessType.API_KEY)).put((Object)ConnectorConstants.TITLE, (Object)"Sendgrid").put((Object)ConnectorConstants.LOGO_URL, (Object)"https://cdn.castled.io/apps/sendgrid.png").put((Object)ConnectorConstants.DOC_URL, (Object)"https://docs.castled.io/getting-started/Destinations/configure-sendgrid").build()),
    MARKETO((Map<String, Object>)ImmutableMap.builder().put((Object)ConnectorConstants.ACCESS_TYPE, (Object)((Object)AccessType.API_KEY)).put((Object)ConnectorConstants.TITLE, (Object)"Marketo").put((Object)ConnectorConstants.LOGO_URL, (Object)"https://cdn.castled.io/apps/marketo.png").put((Object)ConnectorConstants.DOC_URL, (Object)"https://docs.castled.io/getting-started/Destinations/configure-marketo").build()),
    ACTIVECAMPAIGN((Map<String, Object>)ImmutableMap.builder().put((Object)ConnectorConstants.ACCESS_TYPE, (Object)((Object)AccessType.API_KEY)).put((Object)ConnectorConstants.TITLE, (Object)"ActiveCampaign").put((Object)ConnectorConstants.LOGO_URL, (Object)"https://cdn.castled.io/apps/active_campaign.png").build()),
    KAFKA((Map<String, Object>)ImmutableMap.builder().put((Object)ConnectorConstants.ACCESS_TYPE, (Object)((Object)AccessType.API_KEY)).put((Object)ConnectorConstants.TITLE, (Object)"Kafka").put((Object)ConnectorConstants.LOGO_URL, (Object)"https://cdn.castled.io/apps/kafka.png").build()),
    CUSTOMERIO((Map<String, Object>)ImmutableMap.builder().put((Object)ConnectorConstants.ACCESS_TYPE, (Object)((Object)AccessType.API_KEY)).put((Object)ConnectorConstants.TITLE, (Object)"Customer.io").put((Object)ConnectorConstants.LOGO_URL, (Object)"https://cdn.castled.io/apps/customerio.png").build()),
    GOOGLEPUBSUB((Map<String, Object>)ImmutableMap.builder().put((Object)ConnectorConstants.ACCESS_TYPE, (Object)((Object)AccessType.API_KEY)).put((Object)ConnectorConstants.TITLE, (Object)"Google Pub/Sub").put((Object)ConnectorConstants.LOGO_URL, (Object)"https://cdn.castled.io/apps/googlepubsub.png").build()),
    MIXPANEL((Map<String, Object>)ImmutableMap.builder().put((Object)ConnectorConstants.ACCESS_TYPE, (Object)((Object)AccessType.API_KEY)).put((Object)ConnectorConstants.TITLE, (Object)"Mixpanel").put((Object)ConnectorConstants.LOGO_URL, (Object)"https://cdn.castled.io/apps/mixpanel_img.png").build()),
    RESTAPI((Map<String, Object>)ImmutableMap.builder().put((Object)ConnectorConstants.ACCESS_TYPE, (Object)((Object)AccessType.API_KEY)).put((Object)ConnectorConstants.TITLE, (Object)"Rest API").put((Object)ConnectorConstants.LOGO_URL, (Object)"https://cdn.castled.io/apps/restapi.png").build());

    private final Map<String, Object> properties;

    private ExternalAppType(Map<String, Object> properties) {
        this.properties = properties;
    }

    public AccessType getAccessType() {
        return (AccessType)((Object)this.properties.get(ConnectorConstants.ACCESS_TYPE));
    }

    public String title() {
        return (String)this.properties.get(ConnectorConstants.TITLE);
    }

    public String logoUrl() {
        return (String)this.properties.get(ConnectorConstants.LOGO_URL);
    }

    public String docUrl() {
        return (String)this.properties.get(ConnectorConstants.DOC_URL);
    }

    public OAuthServiceType oauthServiceType() {
        OAuthServiceType oauthService = (OAuthServiceType)((Object)this.properties.get(ConnectorConstants.OAUTH_SERVICE));
        return Optional.ofNullable(oauthService).orElse(null);
    }
}

