/*
 * Decompiled with CFR 0.152.
 */
package io.castled.apps;

import com.google.inject.AbstractModule;
import com.google.inject.Binder;
import com.google.inject.Provides;
import com.google.inject.Singleton;
import com.google.inject.multibindings.MapBinder;
import io.castled.apps.ExternalAppConnector;
import io.castled.apps.ExternalAppType;
import io.castled.apps.connectors.activecampaign.ActiveCampaignAppConnector;
import io.castled.apps.connectors.customerio.CIOEventTypeFetcher;
import io.castled.apps.connectors.customerio.CIOPrimaryKeyOptionsFetcher;
import io.castled.apps.connectors.customerio.CustomerIOAppConnector;
import io.castled.apps.connectors.googleads.GadAccountOptionsFetcher;
import io.castled.apps.connectors.googleads.GadsLoginCustomerOptionsFetcher;
import io.castled.apps.connectors.googleads.GoogleAdsAppConnector;
import io.castled.apps.connectors.googlepubsub.GooglePubSubAppConnector;
import io.castled.apps.connectors.googlesheets.GoogleSheetsAppConnector;
import io.castled.apps.connectors.hubspot.HubspotAppConnector;
import io.castled.apps.connectors.intercom.IntercomAppConnector;
import io.castled.apps.connectors.intercom.IntercomCompanySink;
import io.castled.apps.connectors.intercom.IntercomContactSink;
import io.castled.apps.connectors.intercom.IntercomObject;
import io.castled.apps.connectors.intercom.IntercomObjectSink;
import io.castled.apps.connectors.kafka.KafkaAppConnector;
import io.castled.apps.connectors.mailchimp.MailchimpAppConnector;
import io.castled.apps.connectors.marketo.MarketoAppConnector;
import io.castled.apps.connectors.mixpanel.MixpanelAppConnector;
import io.castled.apps.connectors.restapi.RestApiAppConnector;
import io.castled.apps.connectors.salesforce.SalesforceAppConnector;
import io.castled.apps.connectors.sendgrid.SendgridAppConnector;
import io.castled.apps.connectors.sendgrid.SendgridListsOptionsFetcher;
import io.castled.apps.optionfetchers.AppOptionsFetcher;
import io.castled.forms.StaticOptionsFetcher;
import io.castled.jdbc.JdbcConnectionType;
import io.castled.jdbc.JdbcQueryHelper;
import io.castled.jdbc.redshift.RedshiftQueryHelper;
import io.castled.jdbc.snowflake.SnowflakeQueryHelper;
import io.castled.optionsfetchers.appsync.AppSyncOptionsFetcher;
import io.castled.optionsfetchers.appsync.ObjectOptionsFetcher;
import io.castled.optionsfetchers.appsync.SubResourceOptionsFetcher;
import io.castled.optionsfetchers.appsync.SyncModeOptionsFetcher;
import io.castled.warehouses.WarehouseConnector;
import io.castled.warehouses.WarehouseConnectorConfig;
import io.castled.warehouses.WarehouseType;
import io.castled.warehouses.connectors.bigquery.BQLocationsFetcher;
import io.castled.warehouses.connectors.bigquery.BigQueryConnector;
import io.castled.warehouses.connectors.postgres.PostgresQueryHelper;
import io.castled.warehouses.connectors.postgres.PostgresWarehouseConnector;
import io.castled.warehouses.connectors.redshift.RedshiftConnector;
import io.castled.warehouses.connectors.snowflake.SnowflakeConnector;
import io.castled.warehouses.optionsfetchers.WarehouseOptionsFetcher;

public class ConnectorsModule
extends AbstractModule {
    private final WarehouseConnectorConfig warehouseConnectorConfig;

    public ConnectorsModule(WarehouseConnectorConfig warehouseConnectorConfig) {
        this.warehouseConnectorConfig = warehouseConnectorConfig;
    }

    protected void configure() {
        this.bindIntercomObjectSinks();
        this.bindWarehouseConnectors();
        this.bindWarehouseOptionFetchers();
        this.bindAppSyncOptions();
        this.bindJdbcQueryHelpers();
        this.bindStaticOptionFetchers();
        this.bindWarehouseOptionFetchers();
        this.bindAppConnectors();
        this.bindAppOptionFetchers();
    }

    private void bindAppConnectors() {
        MapBinder externalAppConnectorMapping = MapBinder.newMapBinder((Binder)this.binder(), ExternalAppType.class, ExternalAppConnector.class);
        externalAppConnectorMapping.addBinding((Object)ExternalAppType.SALESFORCE).to(SalesforceAppConnector.class);
        externalAppConnectorMapping.addBinding((Object)ExternalAppType.HUBSPOT).to(HubspotAppConnector.class);
        externalAppConnectorMapping.addBinding((Object)ExternalAppType.INTERCOM).to(IntercomAppConnector.class);
        externalAppConnectorMapping.addBinding((Object)ExternalAppType.GOOGLEADS).to(GoogleAdsAppConnector.class);
        externalAppConnectorMapping.addBinding((Object)ExternalAppType.MAILCHIMP).to(MailchimpAppConnector.class);
        externalAppConnectorMapping.addBinding((Object)ExternalAppType.SENDGRID).to(SendgridAppConnector.class);
        externalAppConnectorMapping.addBinding((Object)ExternalAppType.ACTIVECAMPAIGN).to(ActiveCampaignAppConnector.class);
        externalAppConnectorMapping.addBinding((Object)ExternalAppType.MARKETO).to(MarketoAppConnector.class);
        externalAppConnectorMapping.addBinding((Object)ExternalAppType.KAFKA).to(KafkaAppConnector.class);
        externalAppConnectorMapping.addBinding((Object)ExternalAppType.CUSTOMERIO).to(CustomerIOAppConnector.class);
        externalAppConnectorMapping.addBinding((Object)ExternalAppType.GOOGLEPUBSUB).to(GooglePubSubAppConnector.class);
        externalAppConnectorMapping.addBinding((Object)ExternalAppType.MIXPANEL).to(MixpanelAppConnector.class);
        externalAppConnectorMapping.addBinding((Object)ExternalAppType.GOOGLE_SHEETS).to(GoogleSheetsAppConnector.class);
        externalAppConnectorMapping.addBinding((Object)ExternalAppType.RESTAPI).to(RestApiAppConnector.class);
    }

    private void bindWarehouseOptionFetchers() {
        MapBinder warehouseOptionFetchers = MapBinder.newMapBinder((Binder)this.binder(), String.class, WarehouseOptionsFetcher.class);
    }

    private void bindAppOptionFetchers() {
        MapBinder warehouseOptionFetchers = MapBinder.newMapBinder((Binder)this.binder(), String.class, AppOptionsFetcher.class);
    }

    private void bindJdbcQueryHelpers() {
        MapBinder queryHelpers = MapBinder.newMapBinder((Binder)this.binder(), JdbcConnectionType.class, JdbcQueryHelper.class);
        queryHelpers.addBinding((Object)JdbcConnectionType.REDSHIFT).to(RedshiftQueryHelper.class);
        queryHelpers.addBinding((Object)JdbcConnectionType.SNOWFLAKE).to(SnowflakeQueryHelper.class);
        queryHelpers.addBinding((Object)JdbcConnectionType.POSTGRES).to(PostgresQueryHelper.class);
    }

    private void bindWarehouseConnectors() {
        MapBinder warehouseConnectorMapBinder = MapBinder.newMapBinder((Binder)this.binder(), WarehouseType.class, WarehouseConnector.class);
        warehouseConnectorMapBinder.addBinding((Object)WarehouseType.REDSHIFT).to(RedshiftConnector.class);
        warehouseConnectorMapBinder.addBinding((Object)WarehouseType.SNOWFLAKE).to(SnowflakeConnector.class);
        warehouseConnectorMapBinder.addBinding((Object)WarehouseType.BIGQUERY).to(BigQueryConnector.class);
        warehouseConnectorMapBinder.addBinding((Object)WarehouseType.POSTGRES).to(PostgresWarehouseConnector.class);
    }

    private void bindAppSyncOptions() {
        MapBinder optionFetchers = MapBinder.newMapBinder((Binder)this.binder(), String.class, AppSyncOptionsFetcher.class);
        optionFetchers.addBinding((Object)"Object").to(ObjectOptionsFetcher.class);
        optionFetchers.addBinding((Object)"Sub Resource").to(SubResourceOptionsFetcher.class);
        optionFetchers.addBinding((Object)"Sync Mode").to(SyncModeOptionsFetcher.class);
        optionFetchers.addBinding((Object)"Gads Account Id").to(GadAccountOptionsFetcher.class);
        optionFetchers.addBinding((Object)"Gads Login Account Id").to(GadsLoginCustomerOptionsFetcher.class);
        optionFetchers.addBinding((Object)"Sendgrid Lists").to(SendgridListsOptionsFetcher.class);
        optionFetchers.addBinding((Object)"CIO Primary keys").to(CIOPrimaryKeyOptionsFetcher.class);
        optionFetchers.addBinding((Object)"CIO Event Types").to(CIOEventTypeFetcher.class);
    }

    private void bindStaticOptionFetchers() {
        MapBinder staticOptionFetcher = MapBinder.newMapBinder((Binder)this.binder(), String.class, StaticOptionsFetcher.class);
        staticOptionFetcher.addBinding((Object)"BQ_LOCATIONS").to(BQLocationsFetcher.class);
    }

    private void bindIntercomObjectSinks() {
        MapBinder pipelineDataSinks = MapBinder.newMapBinder((Binder)this.binder(), IntercomObject.class, IntercomObjectSink.class);
        pipelineDataSinks.addBinding((Object)IntercomObject.COMPANY).to(IntercomCompanySink.class);
        pipelineDataSinks.addBinding((Object)IntercomObject.CONTACT).to(IntercomContactSink.class);
        pipelineDataSinks.addBinding((Object)IntercomObject.USER).to(IntercomContactSink.class);
        pipelineDataSinks.addBinding((Object)IntercomObject.LEAD).to(IntercomContactSink.class);
    }

    @Provides
    @Singleton
    public WarehouseConnectorConfig providesWarehouseConfig() {
        return this.warehouseConnectorConfig;
    }
}

