/*
 * Decompiled with CFR 0.152.
 */
package io.castled.utils;

import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ThreadUtils {
    private static final Logger log = LoggerFactory.getLogger(ThreadUtils.class);

    public static void interruptIgnoredSleep(long millis) {
        try {
            Thread.sleep(millis);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public static void terminateGracefully(ExecutorService executorService, long waitTimeoutSecs) {
        try {
            executorService.shutdown();
            executorService.awaitTermination(waitTimeoutSecs, TimeUnit.SECONDS);
        }
        catch (InterruptedException e) {
            executorService.shutdownNow();
        }
    }
}

