/*
 * Decompiled with CFR 0.152.
 */
package io.castled.utils;

import io.castled.core.WaitTimeAndRetry;
import io.castled.exceptions.CastledRuntimeException;
import io.castled.functionalinterfaces.ThrowingSupplier;
import io.castled.utils.ThreadUtils;
import java.util.List;
import java.util.function.BiFunction;

public class RetryUtils {
    public static <T> T retrySupplier(ThrowingSupplier<T> supplier, int maxRetries, List<Class<? extends Throwable>> whitelistedExceptions, BiFunction<Throwable, Integer, WaitTimeAndRetry> actionOnError) throws Exception {
        for (int attempts = 0; attempts <= maxRetries; ++attempts) {
            try {
                return supplier.get();
            }
            catch (Throwable e) {
                WaitTimeAndRetry waitTimeAndRetry = actionOnError.apply(e, attempts);
                if (!waitTimeAndRetry.isShouldRetry()) {
                    throw e;
                }
                if (attempts == maxRetries || !RetryUtils.isExceptionWhitelisted(whitelistedExceptions, e)) {
                    throw e;
                }
                ThreadUtils.interruptIgnoredSleep(waitTimeAndRetry.getWaitTimeMs());
                continue;
            }
        }
        throw new CastledRuntimeException("cannot reach here");
    }

    public static boolean isExceptionWhitelisted(List<Class<? extends Throwable>> whitelistedExceptions, Throwable exception) {
        for (Class<? extends Throwable> type : whitelistedExceptions) {
            if (!type.isAssignableFrom(exception.getClass())) continue;
            return true;
        }
        return false;
    }
}

