/*
 * Decompiled with CFR 0.152.
 */
package io.castled.utils;

import com.google.api.client.util.Lists;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;

public class ReflectionUtils {
    public static <A extends Annotation> List<A> getAnnotationsFromType(Class<?> classType, Class<A> annotationClass) {
        ArrayList annotations = Lists.newArrayList();
        while (!classType.getName().equals(Object.class.getName())) {
            annotations.addAll(Arrays.stream(classType.getAnnotationsByType(annotationClass)).collect(Collectors.toList()));
            classType = classType.getSuperclass();
        }
        return annotations;
    }

    public static <A extends Annotation> A getAnnotation(Class<?> classType, Class<A> annotationClass) {
        List<A> annotations = ReflectionUtils.getAnnotationsFromType(classType, annotationClass);
        if (CollectionUtils.isEmpty(annotations)) {
            return null;
        }
        return (A)((Annotation)annotations.get(0));
    }
}

