/*
 * Decompiled with CFR 0.152.
 */
package io.castled.utils;

import com.google.inject.Inject;
import com.google.inject.Singleton;
import io.castled.utils.GenericKeyValueStore;
import io.castled.utils.TimeUtils;
import java.util.UUID;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class OAuthStateStore {
    private static final Logger log = LoggerFactory.getLogger(OAuthStateStore.class);
    private static final String OAUTH_NS = "oauth:";
    private final GenericKeyValueStore kvStore;

    @Inject
    public OAuthStateStore(GenericKeyValueStore kvStore) {
        this.kvStore = kvStore;
    }

    public String persistOAuthState(String state) {
        String uuid = UUID.randomUUID().toString();
        this.kvStore.putKey(OAUTH_NS, uuid, (int)TimeUtils.minutesToMillis(30L), state);
        return uuid;
    }

    public String getOAuthState(String stateId) {
        return this.kvStore.getKey(OAUTH_NS, stateId);
    }
}

