/*
 * Decompiled with CFR 0.152.
 */
package io.castled.utils;

import com.google.inject.Singleton;
import io.castled.exceptions.CastledRuntimeException;
import io.castled.functionalinterfaces.ThrowingConsumer;
import io.castled.utils.JsonUtils;
import java.io.InputStream;
import java.util.Map;
import javax.json.Json;
import javax.json.JsonObject;
import javax.json.stream.JsonParser;
import javax.json.stream.JsonParsingException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class JsonStreamParser {
    private static final Logger log = LoggerFactory.getLogger(JsonStreamParser.class);

    public void parseJsonStream(InputStream inputStream, ThrowingConsumer<Map<String, Object>> recordsConsumer) {
        try {
            JsonParser jsonParser = Json.createParser((InputStream)inputStream);
            JsonParser.Event event = jsonParser.next();
            if (event != JsonParser.Event.START_ARRAY) {
                throw new JsonParsingException("Result Json should start with START_ARRAY tag", jsonParser.getLocation());
            }
            event = jsonParser.next();
            if (event == JsonParser.Event.END_ARRAY) {
                return;
            }
            if (event != JsonParser.Event.START_OBJECT) {
                throw new JsonParsingException("Invalid result json: expected START_OBJECT", jsonParser.getLocation());
            }
            while (event != JsonParser.Event.END_ARRAY) {
                JsonObject record = jsonParser.getObject();
                recordsConsumer.accept(JsonUtils.jsonObjectToMap(record));
                event = jsonParser.next();
            }
        }
        catch (Exception e) {
            log.error("Json stream parse failed", (Throwable)e);
            throw new CastledRuntimeException(e);
        }
    }
}

