/*
 * Decompiled with CFR 0.152.
 */
package io.castled.utils;

import com.google.inject.Inject;
import com.google.inject.Singleton;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import redis.clients.jedis.Jedis;
import redis.clients.jedis.JedisPool;

@Singleton
public class GenericKeyValueStore {
    private static final Logger log = LoggerFactory.getLogger(GenericKeyValueStore.class);
    private final JedisPool jedisPool;

    @Inject
    public GenericKeyValueStore(JedisPool jedisPool) {
        this.jedisPool = jedisPool;
    }

    public void putKey(String nameSpace, String key, int ttlSeconds, String value) {
        try (Jedis jedis = this.jedisPool.getResource();){
            jedis.setex(nameSpace + key, ttlSeconds, value);
        }
    }

    public void putKey(String nameSpace, String key, String value) {
        try (Jedis jedis = this.jedisPool.getResource();){
            jedis.set(nameSpace + key, value);
        }
    }

    public String getKey(String nameSpace, String key) {
        try (Jedis jedis = this.jedisPool.getResource();){
            String string = jedis.get(nameSpace + key);
            return string;
        }
    }
}

