/*
 * Decompiled with CFR 0.152.
 */
package io.castled.utils;

import io.castled.exceptions.CastledRuntimeException;
import io.castled.schema.IncompatibleValueException;
import io.castled.schema.SchemaMapper;
import io.castled.schema.models.FieldSchema;
import io.castled.schema.models.RecordSchema;
import io.castled.schema.models.Tuple;
import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.file.Path;
import java.util.Iterator;
import java.util.zip.GZIPInputStream;
import org.apache.commons.csv.CSVFormat;
import org.apache.commons.csv.CSVParser;
import org.apache.commons.csv.CSVRecord;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CsvStructParser {
    private static final Logger log = LoggerFactory.getLogger(CsvStructParser.class);
    private final Path filePath;
    private final Iterator<CSVRecord> csvRecordIterator;
    private final SchemaMapper schemaMapper;
    private final RecordSchema recordSchema;
    private long readLineNumber = 0L;

    public CsvStructParser(Path filePath, SchemaMapper schemaMapper, RecordSchema recordSchema, boolean gzipped) throws IOException {
        this.filePath = filePath;
        this.schemaMapper = schemaMapper;
        this.recordSchema = recordSchema;
        this.csvRecordIterator = gzipped ? new CSVParser((Reader)new BufferedReader(new InputStreamReader(new GZIPInputStream(new FileInputStream(filePath.toFile())))), CSVFormat.RFC4180.withHeader(new String[0]).withSkipHeaderRecord()).iterator() : new CSVParser((Reader)new BufferedReader(new FileReader(filePath.toFile())), CSVFormat.RFC4180.withHeader(new String[0]).withSkipHeaderRecord()).iterator();
        this.readLineNumber = 1L;
    }

    public Tuple getRecord(long lineNumber) {
        try {
            while (this.csvRecordIterator.hasNext()) {
                CSVRecord csvRecord = this.csvRecordIterator.next();
                ++this.readLineNumber;
                if (this.readLineNumber > lineNumber) {
                    throw new CastledRuntimeException(String.format("Reader has passed reading line number %d", lineNumber));
                }
                if (this.readLineNumber != lineNumber) continue;
                Tuple.Builder recordBuilder = Tuple.builder();
                for (FieldSchema field : this.recordSchema.getFieldSchemas()) {
                    recordBuilder.put(field, this.schemaMapper.transformValue(csvRecord.get(field.getName()), field.getSchema()));
                }
                return recordBuilder.build();
            }
            throw new CastledRuntimeException(String.format("Line number %d not present in file", lineNumber));
        }
        catch (IncompatibleValueException e) {
            log.error("Failed to read csv record in file {}", (Object)this.filePath.toString(), (Object)e);
            throw new CastledRuntimeException(e);
        }
    }
}

