/*
 * Decompiled with CFR 0.152.
 */
package io.castled.schema.models;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import io.castled.schema.exceptions.SchemaValidationException;
import io.castled.schema.models.Field;
import io.castled.schema.models.FieldSchema;
import java.util.List;
import java.util.Map;
import java.util.Optional;

public class Tuple {
    private String name;
    private List<Field> fields;
    private Map<String, Field> fieldMap;

    public void addField(Field field) {
        this.fields.add(field);
        this.fieldMap.put(field.getName(), field);
    }

    public Object getValue(String fieldName) {
        return Optional.ofNullable(this.fieldMap.get(fieldName)).map(Field::getValue).orElse(null);
    }

    public Field getField(String fieldName) {
        return Optional.ofNullable(this.fieldMap.get(fieldName)).orElse(null);
    }

    public static Builder builder() {
        return new Builder();
    }

    public Tuple(String name, List<Field> fields, Map<String, Field> fieldMap) {
        this.name = name;
        this.fields = fields;
        this.fieldMap = fieldMap;
    }

    public Tuple() {
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public List<Field> getFields() {
        return this.fields;
    }

    public static class Builder {
        private final Tuple record = new Tuple(null, Lists.newArrayList(), Maps.newHashMap());

        public Builder put(FieldSchema fieldSchema, Object value) throws SchemaValidationException {
            this.record.addField(new Field(fieldSchema, value));
            return this;
        }

        public Builder put(Field field) {
            this.record.addField(field);
            return this;
        }

        public Builder name(String name) {
            this.record.setName(name);
            return this;
        }

        public Tuple build() {
            return this.record;
        }
    }
}

