/*
 * Decompiled with CFR 0.152.
 */
package io.castled.schema.models;

import com.google.common.collect.Lists;
import io.castled.schema.models.Schema;
import io.castled.schema.models.SchemaType;

public class StringSchema
extends Schema {
    private final int maxLength;

    public StringSchema(boolean optional, int maxLength) {
        super(SchemaType.STRING, Lists.newArrayList((Object[])new Class[]{String.class}), optional);
        this.maxLength = maxLength;
    }

    public static StringSchemaBuilder builder() {
        return new StringSchemaBuilder();
    }

    public int getMaxLength() {
        return this.maxLength;
    }

    public static class StringSchemaBuilder {
        private boolean optional;
        private int maxLength;

        StringSchemaBuilder() {
        }

        public StringSchemaBuilder optional(boolean optional) {
            this.optional = optional;
            return this;
        }

        public StringSchemaBuilder maxLength(int maxLength) {
            this.maxLength = maxLength;
            return this;
        }

        public StringSchema build() {
            return new StringSchema(this.optional, this.maxLength);
        }

        public String toString() {
            return "StringSchema.StringSchemaBuilder(optional=" + this.optional + ", maxLength=" + this.maxLength + ")";
        }
    }
}

