/*
 * Decompiled with CFR 0.152.
 */
package io.castled.schema.models;

import com.fasterxml.jackson.annotation.JsonSubTypes;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import io.castled.schema.exceptions.IncompatibleValueException;
import io.castled.schema.exceptions.NullValueException;
import io.castled.schema.exceptions.SchemaValidationException;
import io.castled.schema.models.IntegerSchema;
import io.castled.schema.models.LongSchema;
import io.castled.schema.models.SchemaType;
import io.castled.schema.models.ShortSchema;
import java.util.List;

@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, include=JsonTypeInfo.As.EXISTING_PROPERTY, visible=true, property="type")
@JsonSubTypes(value={@JsonSubTypes.Type(value=ShortSchema.class, name="SHORT"), @JsonSubTypes.Type(value=LongSchema.class, name="LONG"), @JsonSubTypes.Type(value=IntegerSchema.class, name="INT")})
public abstract class Schema {
    private SchemaType type;
    private List<Class<?>> allowedTypes;
    private boolean optional;

    public void validateValue(String fieldName, Object value) throws SchemaValidationException {
        if (value == null) {
            if (!this.optional) {
                throw new NullValueException(fieldName, this.type);
            }
            return;
        }
        if (this.allowedTypes.stream().noneMatch(allowedType -> allowedType.isInstance(value))) {
            throw new IncompatibleValueException(this.type, value);
        }
    }

    public Schema(SchemaType type, List<Class<?>> allowedTypes, boolean optional) {
        this.type = type;
        this.allowedTypes = allowedTypes;
        this.optional = optional;
    }

    public SchemaType getType() {
        return this.type;
    }

    public List<Class<?>> getAllowedTypes() {
        return this.allowedTypes;
    }

    public boolean isOptional() {
        return this.optional;
    }

    public void setType(SchemaType type) {
        this.type = type;
    }

    public void setAllowedTypes(List<Class<?>> allowedTypes) {
        this.allowedTypes = allowedTypes;
    }

    public void setOptional(boolean optional) {
        this.optional = optional;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Schema)) {
            return false;
        }
        Schema other = (Schema)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.isOptional() != other.isOptional()) {
            return false;
        }
        SchemaType this$type = this.getType();
        SchemaType other$type = other.getType();
        if (this$type == null ? other$type != null : !((Object)((Object)this$type)).equals((Object)other$type)) {
            return false;
        }
        List<Class<?>> this$allowedTypes = this.getAllowedTypes();
        List<Class<?>> other$allowedTypes = other.getAllowedTypes();
        return !(this$allowedTypes == null ? other$allowedTypes != null : !((Object)this$allowedTypes).equals(other$allowedTypes));
    }

    protected boolean canEqual(Object other) {
        return other instanceof Schema;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isOptional() ? 79 : 97);
        SchemaType $type = this.getType();
        result = result * 59 + ($type == null ? 43 : ((Object)((Object)$type)).hashCode());
        List<Class<?>> $allowedTypes = this.getAllowedTypes();
        result = result * 59 + ($allowedTypes == null ? 43 : ((Object)$allowedTypes).hashCode());
        return result;
    }

    public String toString() {
        return "Schema(type=" + (Object)((Object)this.getType()) + ", allowedTypes=" + this.getAllowedTypes() + ", optional=" + this.isOptional() + ")";
    }

    public Schema() {
    }
}

