/*
 * Decompiled with CFR 0.152.
 */
package io.castled.schema.models;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import io.castled.schema.exceptions.DuplicateFieldException;
import io.castled.schema.models.FieldSchema;
import io.castled.schema.models.Schema;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;

public class RecordSchema {
    private String name;
    private List<FieldSchema> fieldSchemas;
    private Map<String, FieldSchema> fieldSchemaMapping;

    public void addFieldSchema(FieldSchema fieldSchema) throws DuplicateFieldException {
        if (this.fieldSchemaMapping.containsKey(fieldSchema.getName())) {
            throw new DuplicateFieldException(fieldSchema.getName());
        }
        this.fieldSchemas.add(fieldSchema);
        this.fieldSchemaMapping.put(fieldSchema.getName(), fieldSchema);
    }

    public void removeFieldSchema(List<FieldSchema> schemas) {
        this.fieldSchemas.removeAll(schemas);
        this.fieldSchemaMapping.keySet().removeAll(this.fieldSchemas.stream().map(fieldSchema -> fieldSchema.getName()).collect(Collectors.toList()));
    }

    public Schema getSchema(String fieldName) {
        return Optional.ofNullable(this.fieldSchemaMapping.get(fieldName)).map(FieldSchema::getSchema).orElse(null);
    }

    public FieldSchema getFieldSchema(String fieldName) {
        return this.fieldSchemaMapping.get(fieldName);
    }

    public static Builder builder() {
        return new Builder();
    }

    public RecordSchema(String name, List<FieldSchema> fieldSchemas, Map<String, FieldSchema> fieldSchemaMapping) {
        this.name = name;
        this.fieldSchemas = fieldSchemas;
        this.fieldSchemaMapping = fieldSchemaMapping;
    }

    public RecordSchema() {
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public List<FieldSchema> getFieldSchemas() {
        return this.fieldSchemas;
    }

    public static class Builder {
        private final RecordSchema recordSchema = new RecordSchema(null, Lists.newArrayList(), Maps.newHashMap());

        public Builder name(String name) {
            this.recordSchema.setName(name);
            return this;
        }

        public Builder put(String name, Schema schema) {
            this.recordSchema.addFieldSchema(new FieldSchema(name, schema));
            return this;
        }

        public Builder put(String name, Schema schema, Map<String, Object> params) {
            this.recordSchema.addFieldSchema(new FieldSchema(name, schema, params));
            return this;
        }

        public RecordSchema build() {
            return this.recordSchema;
        }
    }
}

