/*
 * Decompiled with CFR 0.152.
 */
package io.castled.schema.models;

import io.castled.schema.exceptions.SchemaValidationException;
import io.castled.schema.models.FieldSchema;
import io.castled.schema.models.Schema;
import java.util.Map;

public class Field {
    private String name;
    private Schema schema;
    private Object value;
    private Map<String, Object> params;

    public Field(FieldSchema fieldSchema, Object value) throws SchemaValidationException {
        this.schema = fieldSchema.getSchema();
        this.name = fieldSchema.getName();
        this.value = value;
        this.params = fieldSchema.getParams();
        this.schema.validateValue(fieldSchema.getName(), value);
    }

    public Field() {
    }

    public String getName() {
        return this.name;
    }

    public Schema getSchema() {
        return this.schema;
    }

    public Object getValue() {
        return this.value;
    }

    public Map<String, Object> getParams() {
        return this.params;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setSchema(Schema schema) {
        this.schema = schema;
    }

    public void setValue(Object value) {
        this.value = value;
    }

    public void setParams(Map<String, Object> params) {
        this.params = params;
    }
}

